/*** HELP START ***//*
 
## >>> `%bpPIPE()` macro: <<< <a name="bppipe-macro"></a> #######################  

The bpPIPE() [Base Plus PIPE] macro executes OS command
and print to the log output of the execution.

Under the hood it uses `_` filename reference to PIPE device.

### SYNTAX: ###################################################################

The basic syntax is the following, the `<...>` means optional parameters:
~~~~~~~~~~~~~~~~~~~~~~~sas
%bpPIPE( <OS command goes here> )
~~~~~~~~~~~~~~~~~~~~~~~

**Arguments description**:

* **NO Arguments**    - Everything inside brackets is treated as an OS command.

---

*//*** HELP END ***/


%macro bpPIPE()/parmbuff;
%if XCMD=%sysfunc(getoption(xcmd)) %then
  %do;
    filename _ PIPE %sysfunc(quote(%superq(syspbuff),"")) ;
    %local temp_opts;
    %let temp_opts = %sysfunc(getoption(notes)) %sysfunc(getoption(ps,KEYWORD)) %sysfunc(getoption(ls,KEYWORD)) ;
    options nonotes ps=max ls=max ;
    data _null_ ;
      infile _ ;
      input ;
      put _infile_ ;
    run ;
    filename _ clear ;
    options &temp_opts.;
  %end;
%else
  %do;
    %put NOTE:[&syshostname.] The XCMD is off!;
  %end;
%mend bpPIPE;




/*** HELP START ***//*
 
### EXAMPLES AND USECASES: ####################################################

**EXAMPLE 1.** List, to the log, content of D and C drives:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %bpPIPE(D: & dir & dir "C:\")
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**EXAMPLE 2.** List, to the log, content of `home` directory:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %bpPIPE(ls -halt ~/)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

---

*//*** HELP END ***/

/**###################################################################**/
/*                                                                     */
/*  Copyright Bartosz Jablonski, since 2020.                           */
/*                                                                     */
/*  Code is under the MIT license. If you want - you can use it.       */
/*  But it comes with absolutely no warranty whatsoever.               */
/*  If you cause any damage or something - it will be your own fault.  */
/*  You've been warned! You are using it on your own risk.             */
/*  However, if you decide to use it don't forget to mention author.   */
/*  Bartosz Jablonski (yabwon@gmail.com)                               */
/*                                                                     */
/**###################################################################**/
