/*** HELP START ***//*
 
## >>> `%LVarNmLab()` macro: <<< <a name="lvarnmlab-macro"></a> #######################  

The LVarNmLab() macro function supports LVarNm() and allows to remember "user names" in labels.

The motivation for the macro was similar one as for the LDSN() macro. 

---

See examples in LVarNm() documentation for the details.

The `%LVarNmLab()` macro executes like a pure macro code.

**Known "Limitations":**

- variable name _cannot_ contain unpaired quotes (`'` and `"`), 
  text: `a "hot-dog"` is ok, but `John's dog` is not!

**Behaviour:**

- variable name text is *converted to upcase*

- variable name text *leading and trailing spaces are ignored*, 
  e.g. the following will give the same hash digest:
  `%LVarNmLab(test)`, `%LVarNmLab( test)`, `%LVarNmLab(test )`.

### SYNTAX: ###################################################################

The basic syntax is the following, the `<...>` means optional parameters:
~~~~~~~~~~~~~~~~~~~~~~~sas
%LVarNmLab(
   arbitrary text string (in line with limitations)
)
~~~~~~~~~~~~~~~~~~~~~~~

---

*//*** HELP END ***/

%macro LVarNmLab()/PARMBUFF; /* to build a label */
%if %length( %superq(SYSPBUFF) ) > 2 %then
  %do;
    %local len;
    %let len = %eval(%length(&SYSPBUFF.)-2);
    %let SYSPBUFF = %upcase(%substr(&SYSPBUFF.,2, &len.));
    %let SYSPBUFF = &SYSPBUFF.;

    %put NOTE: A label `%superq(SYSPBUFF)` is set; 
    %put NOTE- for variable: Var_%sysfunc(MD5((&SYSPBUFF.)),hex16.)_;

    %do;label Var_%sysfunc(MD5((&SYSPBUFF.)),hex16.)_ = "%superq(SYSPBUFF)";%end;
  %end;
%else
  %do;
    %put NOTE: A empty label is set; 
    %put NOTE- for variable: Var_%sysfunc(MD5(&SYSPBUFF.),hex16.)_;
    %do;label Var_%sysfunc(MD5(&SYSPBUFF.),hex16.)_ = " ";%end;
  %end;
%mend LVarNmLab;


/**###################################################################**/
/*                                                                     */
/*  Copyright Bartosz Jablonski, since 2022.                           */
/*                                                                     */
/*  Code is under the MIT license. If you want - you can use it.       */
/*  But it comes with absolutely no warranty whatsoever.               */
/*  If you cause any damage or something - it will be your own fault.  */
/*  You've been warned! You are using it on your own risk.             */
/*  However, if you decide to use it don't forget to mention author.   */
/*  Bartosz Jablonski (yabwon@gmail.com)                               */
/*                                                                     */
/**###################################################################**/
