/*** HELP START ***//*
 
## >>> `%splitDSIntoParts()` macro: <<< <a name="splitdsintoparts-macro"></a> #######################  

The splitDSIntoParts() macro allows to split the `set` dataset into `parts` parts 
of approximately `NOBS/parts` size in datasets: `prefix1` to `prefixN`.

The splitDSIntoParts() macro internally runs the splitDSIntoBlocks() macro.

Macro covers `BASE` engine (`v9`, `v8`, `v7`, `v6`) and `SPDE` engine datasets.

See examples below for the details.

### SYNTAX: ###################################################################

The basic syntax is the following, the `<...>` means optional parameters:
~~~~~~~~~~~~~~~~~~~~~~~sas
%splitDSIntoParts(
    parts
  <,set>
  <,prefix>
)
~~~~~~~~~~~~~~~~~~~~~~~

**Arguments description**:

1. `parts`       - *Required*, the number of parts to split data into.
                   Number of parts must be positive integer.

2. `set`         - *Required/Optional*, the name of the dataset to split.
                   If empty then `&syslast.` is used.

3. `prefix`      - *Required/Optional*, the name-prefix for new datasets.
                   If missing then set to `part`. 

---

*//*** HELP END ***/

%macro splitDSIntoParts(
 parts
,set
,prefix
);
  %if %superq(prefix)= %then
    %do;
      %let prefix=part;
    %end;
  %if %superq(set)= %then
    %do;
      %let set=&syslast.;
    %end;
  data _null_;
    parts = int(symgetn('parts'));
    if parts < 1 then 
      do; 
        put "ERROR: [&sysmacroname.] Number of parts must be positive integer!" parts=; 
        stop; 
      end;

    blockSize = ceil(NobsInSource/parts);
    if blockSize < 1 then 
      do; 
        put "ERROR: [&sysmacroname.] Block size must be positive integer!" blockSize=; 
        stop; 
      end;

    call execute(cats(
    '%nrstr(%splitDSIntoBlocks(',blockSize,",&set.,&prefix.));"
    ));

    stop;
    set &set.(drop=_all_) nobs=NobsInSource;
  run;
%mend splitDSIntoParts;



/*
Error handling test:

%splitDSIntoParts(2, blablabla)
*/


/*** HELP START ***//*
 
### EXAMPLES AND USECASES: ####################################################

**EXAMPLE 1.** Split `sashelp.cars` into 7 parts: datasets carsInParts1 to carsInParts7:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %splitDSIntoParts(7,sashelp.cars, carsInParts)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**EXAMPLE 2.** By default splits the `_last_` dataset into `part1` to `part3` datasets:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  data lastData;
    set sashelp.cars;
  run;

  %splitDSIntoBlocks(3)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**EXAMPLE 3.** Works with `SPDE` engine too:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  options dlcreatedir;
  libname test "%sysfunc(pathname(work))/testSPDE";
  libname test;
  libname test SPDE "%sysfunc(pathname(work))/testSPDE";

  data test.test;
    set sashelp.cars;
  run;

  %splitDSIntoParts(3,test.test,work.spde)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

---

*//*** HELP END ***/

/**###################################################################**/
/*                                                                     */
/*  Copyright Bartosz Jablonski, since 2023 onward.                    */
/*                                                                     */
/*  Code is under the MIT license. If you want - you can use it.       */
/*  But it comes with absolutely no warranty whatsoever.               */
/*  If you cause any damage or something - it will be your own fault.  */
/*  You've been warned! You are using it on your own risk.             */
/*  However, if you decide to use it don't forget to mention author.   */
/*  Bartosz Jablonski (yabwon@gmail.com)                               */
/*                                                                     */
/**###################################################################**/
