/*** HELP START ***//*
 
## >>> `delDataset()` function: <<< <a name="deldataset-function"></a> #######################  

The **delDataset()** function is a "wrapper" 
for the `Fdelete()` function. 
`delDataset()` function uses a text string with 
a dataset name as an argument.

Function checks for `*.sas7bdat`, `*.sas7bndx`, 
and `*.sas7bvew` files and delete them.
Return code of 0 means dataset was deleted.

For compound library files are 
deleted from _ALL_ locations!


*Note:*
Currently only the BASE SAS engine datasets/views are deleted.

Tested on Windows and Linux. Not tested on Z/OS.

### SYNTAX: ###################################################################

The basic syntax is the following, the `<...>` means optional parameters:
~~~~~~~~~~~~~~~~~~~~~~~sas
delDataset(lbds_)
~~~~~~~~~~~~~~~~~~~~~~~

**Arguments description**:

1. `lbds_` - *Required*, character argument containing 
             name of the dataset/view to be deleted.
             The `_last_` special name is honored.

*//*** HELP END ***/

function delDataset(
  lbds_ $ /* character argument containing 
             name of the dataset to be deleted */
);
    length 
      F $ 8      /* filename reference string */
      ds $ 32    /* string with dataset name */
      lbs $ 8192 /* string with library path, 
                    possibly multiple paths for compound libraries */
      lb  $ 2048 /* string with single library path */
      lbds $ 41; /* string for standardizing dataset name */

    F = cats("_", put(datetime(), hex7.));

    lbds = strip(lowcase(lbds_));
    if lbds = '_last_' then lbds = lowcase(symget("syslast"));

    ds = scan(lbds, -1, ".");
    if index(lbds, ".")>0 then lbs = pathname(scan(lbds, 1, "."));
                          else lbs = pathname(ifc(LIBREF("user"), "work", "user"));
    
    /* array with the list of extensions */
    array ext[3] $ 12 (".sas7bdat", ".sas7bndx", ".sas7bvew");
    
    /* for compound library delete from _ALL_ locations! */
    j = 1; 
    lb = dequote(scan(lbs, j, "( )", "Q"));
    _RCV_ = 1;

    do while(lb NE " ");
      /*put lbds lb ds;*/
      
      do i = 1 to dim(ext);
        _RC_ = filename(F, cats(lb, "/", ds, ext[i]), "disk");
        _RCV_ = _RCV_ * fdelete(F);
      end;
      _RC_ = filename(F);

    j + 1;
    lb = dequote(scan(lbs, j, "( )", "Q"));
    end;
    return(_RCV_);
  endsub;

/*** HELP START ***//*
 
### EXAMPLES AND USECASES: ####################################################

**EXAMPLE 1.**
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  data TEST1 TEST2(index=(x));
    x = 17;
  run;

  data TEST3 / view=TEST3;
    set test1;
  run;

  data _null_;
    p = delDataset("WORK.TEST1");
    put p=;

    p = delDataset("TEST2");
    put p=;

    p = delDataset("WORK.TEST3");
    put p=;
  run;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**Example 2.**
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  data TEST4;
    x=42;
  run;
  data _null_;
    p = delDataset("_LAST_");
    put p=;
  run;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**Example 3.**
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  options dlcreatedir;
  libname user "%sysfunc(pathname(work))/user";

  data TEST5;
    x=42;
  run;

  data _null_;
    p = delDataset("test5");
    put p=;
  run;

  libname user clear;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**Example 4.**
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  data TEST6;
    x=42;
  run;

  %put *%sysfunc(delDataset(test6))*;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**Example 5.**
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  options dlcreatedir;
  libname L1 "%sysfunc(pathname(work))/L)1";
  libname L2 "%sysfunc(pathname(work))/L(2";
  libname L3 "%sysfunc(pathname(work))/L'3";

  data L1.TEST7 L2.TEST7 L3.TEST7;
    x=42;
  run;

  libname L12 ("%sysfunc(pathname(work))/L(1" "%sysfunc(pathname(work))/L)2");
  libname L1L2 (L2 L3);

  %put *%sysfunc(delDataset(L12.test7))*;
  %put *%sysfunc(delDataset(L1L2.test7))*;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

---

*//*** HELP END ***/


/*
    _RC0_ = filename(F, cats(lb,"/", ds ,".sas7bdat"), "disk");
    _RCD_ = fdelete(F);

    _RC0_ = filename(F, cats(lb,"/", ds ,".sas7bndx"), "disk");
    _RCI_ = fdelete(F);

    _RC0_ = filename(F, cats(lb,"/", ds ,".sas7bvew"), "disk");
    _RCV_ = fdelete(F);
*/
/*return(_RCD_ * _RCI_ * _RCV_);*/
