
/*** HELP START ***//*
 
## >>> `bplength` format/informat: <<< <a name="bplength-format"></a> #######################

The **bplength** format and informats use the `lengthn()` function
to count the number of bytes in a word.


### EXAMPLES AND USECASES: #################################################### 

**Example 1.** Informats and format:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
data work.count_bytes;
  input x $ 32.;
  n = input (x, bplength.);
  c = input (x, $bplength.);
  format x $bplength.;
cards;
ż
żó
żół
żółć
a 
ab 
abc 
abcd
空
空手
空手道
1
12
123
1234
12345
123456
1234567
12345678
123456789
1234567890
;
run;
proc print data=work.count_bytes;
run;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

**Example 2.** Format:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
data _null_;
  length x $ 32767;
  do i = 32767/3 to 0 by -1111, 10 to 0 by -1;
    x=repeat("空",i);
    put x $bplength.;
  end;
run; 
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

--- 

*//*** HELP END ***/


invalue bplength (default=32767)
  other=[lengthn()]
;

invalue $ bplength (default=12)
  other=[lengthn()]
;

value $ bplength (default=32)
  other=[lengthn()]
;



/**###################################################################**/
/*                                                                     */
/*  Copyright Bartosz Jablonski, since 2024.                           */
/*                                                                     */
/*  Code is under the MIT license. If you want - you can use it.       */
/*  But it comes with absolutely no warranty whatsoever.               */
/*  If you cause any damage or something - it will be your own fault.  */
/*  You've been warned! You are using it on your own risk.             */
/*  However, if you decide to use it don't forget to mention author.   */
/*  Bartosz Jablonski (yabwon@gmail.com)                               */
/*                                                                     */
/**###################################################################**/
