/*** HELP START ***//*
 
## >>> `fromMissingToNumberBS()` function: <<< <a name="frommissingtonumberbs-function"></a> #######################  

The **fromMissingToNumberBS()** function 
gets numeric missing value or a number 
as an argument and returns an integer 
from 1 to 29.

For a numeric missing argument 
the returned values are:
- 1 for `._`
- 2 for `.`
- 3 for `.a`
-   ...
- 28 for `.z` and
- 29 for *all other*.

The function is used **internally** by 
functions in the *BasePlus* package.

For *missing value arguments* the function
is an inverse of the `fromNumberToMissing()` function.

### SYNTAX: ###################################################################

The basic syntax is the following, the `<...>` means optional parameters:
~~~~~~~~~~~~~~~~~~~~~~~sas
fromMissingToNumberBS(x)
~~~~~~~~~~~~~~~~~~~~~~~

**Arguments description**:

1. `x` - A numeric missing value or a number.

*//*** HELP END ***/

function fromMissingToNumberBS(x); /* argument is numeric missing value or a number */
/* binary search version */
  select;
    when(x = . ) return (2 ); /* mind the order! */
    when(x = ._) return (1 );
    /* do binary search */
    when(x <= .N) do;
      if x <= .G then 
        do;
          if x <= .D then
            do;
              if x <= .B then
                do;
                  if (x = .A ) then return (3 ); /*A*/
                               else return (4 ); /*B*/
                end;
              else
                do;
                  if (x = .C ) then return (5 ); /*C*/
                               else return (6 ); /*D*/
                end;
            end;
          else
            do;
              if x = .E then return (7 );       /*E*/
              else if x = .F then return (8 );  /*F*/
                             else return (9 );  /*G*/
            end;
        end;
      else
        do;
          if x <= .K then
            do;
              if x <= .I then
                do;
                  if (x = .H ) then return (10); /*H*/
                               else return (11); /*I*/
                end;
              else
                do;
                  if (x = .J ) then return (12); /*J*/
                               else return (13); /*K*/
                end;
            end;
          else
            do;
              if x = .L then return (14);      /*L*/
              else if x = .M then return (15); /*M*/
                             else return (16); /*N*/
            end;
        end;
      end;
    otherwise do;
      if x <= .U then 
        do;
          if x <= .R then
            do;
              if x <= .P then
                do;
                  if (x = .O ) then return (17); /*O*/
                               else return (18); /*P*/
                end;
              else
                do;
                  if (x = .Q ) then return (19); /*Q*/
                               else return (20); /*R*/
                end;
            end;
          else
            do;
              if x = .S then return (21);      /*S*/
              else if x = .T then return (22); /*T*/
                             else return (23); /*U*/
            end;
        end;
      else
        do;
          if x <= .X then
            do;
              if x = .V then return (24);      /*V*/
              else if x = .W then return (25); /*W*/
                             else return (26); /*X*/
            end;
          else
            do;
              if x = .Y then return (27);      /*Y*/
              else if x = .Z then return (28); /*Z*/
                             else return (29); /*other*/
            end;
        end;
    end;
  end;
endsub;

/*** HELP START ***//*
 
### EXAMPLES AND USECASES: ####################################################

**EXAMPLE 1.**
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  data _null_;
    do x = ._, ., .a, .b, .c, 42;
      y = fromMissingToNumberBS(x);
      put x= y=; 
    end;
  run;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

---

*//*** HELP END ***/
