
/*** HELP START ***//*
 
## >>> `%fmt()` macro: <<< <a name="fmt-macro"></a> #######################  

The fmt() macro function returns a `value` formatted by a `format`,
it is a wrapper to `putN()` and `putC()` functions.

See examples below for the details.

The `%fmt()` macro executes like a pure macro code.

### SYNTAX: ###################################################################

The basic syntax is the following, the `<...>` means optional parameters:
~~~~~~~~~~~~~~~~~~~~~~~sas
%fmt(
  value
 ,format
 ,align
 <,type=>
)
~~~~~~~~~~~~~~~~~~~~~~~

**Arguments description**:

1. `value`  - *Required*, a value to be formatted.

2. `format` - *Required*, a name of a format to be used,
              character format should be preceded by the `$`.

3. `align`  - *Optional*, allows to use the `-L`, `-R` and `-C` modifiers.

*  `type=n` - *Optional*, defines type of the format. If the format
              name is preceded by the `$` then C is set automatically.
              If the character format name is without `$` then set
              value to `C` yourself.

---

*//*** HELP END ***/

%macro fmt(value,format,align,TYPE=N);
%if $=%substr(%superq(format),1,1) %then %let TYPE=C;
%sysfunc(put&TYPE.(&value.,&format. &align.))
%mend fmt;



/*** HELP START ***//*
 
### EXAMPLES AND USECASES: ####################################################

**EXAMPLE 1.** Formatting values:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %put %fmt(111, 7.2);

  %put %fmt(111, dollar10.2);

  %put %fmt(abc, $upcase.);

  %put %fmt(12345, date9.);
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

**EXAMPLE 2.** Align values (compare different results!):
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %put *%fmt(ABC, $char9., -L)*;
  %put *%fmt(ABC, $char9., -R)*;
  %put *%fmt(ABC, $char9., -C)*;

  %put %fmt(ABC, $char9., -L);
  %put %fmt(ABC, $char9., -R);
  %put %fmt(ABC, $char9., -C);
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

---

*//*** HELP END ***/

/**###################################################################**/
/*                                                                     */
/*  Copyright Bartosz Jablonski, since 2023.                           */
/*                                                                     */
/*  Code is under the MIT license. If you want - you can use it.       */
/*  But it comes with absolutely no warranty whatsoever.               */
/*  If you cause any damage or something - it will be your own fault.  */
/*  You've been warned! You are using it on your own risk.             */
/*  However, if you decide to use it don't forget to mention author.   */
/*  Bartosz Jablonski (yabwon@gmail.com)                               */
/*                                                                     */
/**###################################################################**/








