

/*** HELP START ***//*
 
## >>> `%infmt()` macro: <<< <a name="infmt-macro"></a> #######################  

The infmt() macro function returns a `value` read in by an `informat`,
it is a wrapper to `inputN()` and `inputC()` functions.

See examples below for the details.

The `%infmt()` macro executes like a pure macro code.

### SYNTAX: ###################################################################

The basic syntax is the following, the `<...>` means optional parameters:
~~~~~~~~~~~~~~~~~~~~~~~sas
%infmt(
  value
 ,informat
 <,type=>
)
~~~~~~~~~~~~~~~~~~~~~~~

**Arguments description**:

1. `value`    - *Required*, a value to be formatted.

2. `informat` - *Required*, a name of a format to be used,
                character format should be preceded by the `$`.

*  `type=n`   - *Optional*, defines type of the informat. If the informat
                name is preceded by the `$` then C is set automatically.
                If the character format name is without `$` then set
                value to `C` yourself.

---

*//*** HELP END ***/

%macro infmt(value,informat,TYPE=N);
%if $=%substr(%superq(informat),1,1) %then %let TYPE=C;
%sysfunc(input&TYPE.(&value.,&informat.))
%mend infmt;


/*** HELP START ***//*
 
### EXAMPLES AND USECASES: ####################################################

**EXAMPLE 1.** Informatting values:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %put %infmt(111, 7.2);
  %put %infmt(111.234, 7.2);

  %put %infmt($111, dollar10.2);
  %put %infmt($111.234, dollar10.2);

  %put %infmt(abc, $upcase.);

  %put %infmt(12mar45, date9.);
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

---

*//*** HELP END ***/

/**###################################################################**/
/*                                                                     */
/*  Copyright Bartosz Jablonski, since 2023.                           */
/*                                                                     */
/*  Code is under the MIT license. If you want - you can use it.       */
/*  But it comes with absolutely no warranty whatsoever.               */
/*  If you cause any damage or something - it will be your own fault.  */
/*  You've been warned! You are using it on your own risk.             */
/*  However, if you decide to use it don't forget to mention author.   */
/*  Bartosz Jablonski (yabwon@gmail.com)                               */
/*                                                                     */
/**###################################################################**/




