/*** HELP START ***//*
 
## >>> `%tranwrd()` macro: <<< <a name="tranwrd-macro"></a> #######################  

The tranwrd() macro function allows to replace substrings 
with other substrings in text string.

Returned string is unquoted by `%unquote()`.

See examples below for the details.

The `%tranwrd()` macro executes like a pure macro code.

### SYNTAX: ###################################################################

The basic syntax is the following, the `<...>` means optional parameters:
~~~~~~~~~~~~~~~~~~~~~~~sas
%tranwrd(
    string
   ,from
   ,to
  <,repeat>
)
~~~~~~~~~~~~~~~~~~~~~~~

**Arguments description**:

1. `string`       - *Required*, string to modify.

2. `from`         - *Required*, substring replaced with 
                    corresponding string from `to`.

3. `to`           - *Required*, substring replacing
                    corresponding substring from `from`. 

4. `repeat`       - *Optional*, number of times the replacing
                    should be repeated, default is 1.
                    Useful while removing multiple adjacent 
                    characters, e.g. compress all multiple 
                    spaces (see example 2).
---

*//*** HELP END ***/

%macro tranwrd(string,from,to,repeat);
%if %superq(repeat)= %then %let repeat=1;
%do repeat=1 %to &repeat.;
%let string=%qsysfunc(tranwrd(%superq(string),%superq(from),%superq(to)));
%end;
%unquote(&string.)
%mend tranwrd;

/*
%put %tranwrd(A Ą A,Ą,B);
%put %tranwrd(%translate(ABC AB C,ABC,___),__,_,5);
%put %translate(%libpath(sashelp),(),%str(  ));
*/

/*** HELP START ***//*
 
### EXAMPLES AND USECASES: ####################################################

**EXAMPLE 1.** Simple text replacement:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %put %tranwrd(Miss Joan Smith,Miss,Ms.);
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**EXAMPLE 2.** Delete multiple spaces;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %put %tranwrd(%str(A      B   C),%str(  ),%str( ),5);
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**EXAMPLE 3.** Remove substring:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
    %put %tranwrd(ABCxyzABCABCxyzABC,ABC);
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

---

*//*** HELP END ***/

/**###################################################################**/
/*                                                                     */
/*  Copyright Bartosz Jablonski, since 2023.                           */
/*                                                                     */
/*  Code is under the MIT license. If you want - you can use it.       */
/*  But it comes with absolutely no warranty whatsoever.               */
/*  If you cause any damage or something - it will be your own fault.  */
/*  You've been warned! You are using it on your own risk.             */
/*  However, if you decide to use it don't forget to mention author.   */
/*  Bartosz Jablonski (yabwon@gmail.com)                               */
/*                                                                     */
/**###################################################################**/
