/*** HELP START ***//*
 
## >>> `bit64andPROTOdfa()` proto function: <<< <a name="bit64andprotodfa-proto-function"></a> #######################  

The **bit64andPROTOdfa()** is external *C* function, 
this is the implementation of the *bitwise AND* operation
on doubles. A double is returned. 

**Caution!** For SAS numeric values *only* operations on first 53 bits are valid! 

The function is used **internally** by functions in the *DFA* package.

### SYNTAX: ###################################################################

The basic syntax is the following:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
bit64andPROTOdfa(i, j)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

**Arguments description**:

1. `i`  - A double numeric argument.

2. `j`  - A double numeric argument.

---

*//*** HELP END ***/

double bit64andPROTOdfa(double i, double j);

externC bit64andPROTOdfa;
double bit64andPROTOdfa(double i, double j)
{
    return (double)( (long long)i & (long long)j );
    /* bit operation doesn't work on doubles so casting is needed: double->int64->(bit and)->double */
}
externCend;
