/*** HELP START ***//*
 
## >>> `bit64orPROTOdfa()` proto function: <<< <a name="bit64orprotodfa-proto-function"></a> #######################  

The **bit64orPROTOdfa()** is external *C* function, 
this is the implementation of the *bitwise OR* operation
on doubles. A double is returned. 

**Caution!** For SAS numeric values *only* operations on first 53 bits are valid! 

The function is used **internally** by functions in the *DFA* package.

### SYNTAX: ###################################################################

The basic syntax is the following:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
bit64orPROTOdfa(i, j)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

**Arguments description**:

1. `i`  - A double numeric argument.

2. `j`  - A double numeric argument.

---

*//*** HELP END ***/

double bit64orPROTOdfa(double i, double j);

externC bit64orPROTOdfa;
double bit64orPROTOdfa(double i, double j) 
{
  return (double)( (long long)i | (long long)j ); 
  /* bit operation doesn't work on doubles so casting is needed: double->int64->(bit or)->double */
}
externCend;
