/*** HELP START ***//*
 
## >>> `bit64andDFA()` subroutine: <<< <a name="bit64anddfa-function"></a> #######################  

The **bit64andDFA()** function is an alternative to 
the 32 bit bitwise `BAND()` function working on SAS numerics.
Allows to work on *up to* 53 bits of SAS numeric value.

The `bit64andDFA()` is an *internal* function of the `DFA` package.

### SYNTAX: ###################################################################

The basic syntax is the following, the `<...>` means optional parameters:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
bit64andDFA(a, b)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

**Arguments description**:

1. `a` - Argument is a SAS numeric values.

2. `B` - Argument is a SAS numeric values.

*//*** HELP END ***/

function bit64andDFA(a, b);
  return( bit64andPROTOdfa(a, b) );
endsub; 


/*** HELP START ***//*
 
### EXAMPLES AND USECASES: ####################################################

**EXAMPLE 1.** Basic test of `bit64orDFA()` and `bit64andDFA()`
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  options ls = max ps = max;
  %let M = 53 ; %* 53 is maximum valid value;
  data _null_;
    array bitmask [ 0: &M] _temporary_ ;
    do P = 1 to &M ;
      bitmask[P] = 2**(P-1) ;
      put bitmask[P] = binary54. @;
      put bitmask[P] = best32.; 
    end ;
    bitmask[0] = bitmask[&M.] ;
      put bitmask[0] = best32. /;

      a=0;
      put a = binary54.;
      do P = 1 to &M ;
        a = BIT64ORDFA (a, bitmask[P]) ;
        put a = binary54.;
      end;
      put;
      
      b = 0;
      put b = binary54./;
      do P = 1 to &M ;
        b + (BIT64ANDDFA (a, bitmask[P]) ne .) ;
        put b = best32.;
      end;
  run;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

---

*//*** HELP END ***/
