/*** HELP START ***//*
 
## >>> `generateArrays` exec: <<< <a name="createdhprtqueue-exec"></a> #######################
 
The generateArrays exec file provides a **list of automatically generated examples** of functions
emulating data structures.

The list of provided examples is the following:
- `SmpArray` - Simple Immutable Dynamic Function Array
- `SmpMtbArray` - Simple Mutable Dynamic Function Array
- `SrchArray` - Searchable Immutable Dynamic Function Array
- `SrchMtbArray` - Searchable Mutable Dynamic Function Array
- `DynArrayC` - Dynamic Hash-based Character Function Array (length 256 bytes)
- `StackC` - Dynamic Hash-based Character Stack (length 256 bytes)
- `StackN` - Dynamic Hash-based Numeric Stack
- `FifoC` - Dynamic Hash-based Character Fifo (length 256 bytes)
- `FifoN` - Dynamic Hash-based Character Fifo
- `DescStackC` - Dynamic Hash-based Character Descending Ordered Stack (length 256 bytes)
- `AscStackC` - Dynamic Hash-based Character Ascending Ordered Stack (length 256 bytes)
- `DescStackN` - Dynamic Hash-based Numeric Descending Ordered Stack
- `AscStackN` - Dynamic Hash-based Numeric Ascending Ordered Stack
- `PrtQueueNTC` - Dynamic Hash-based Character Priority Queue with *New on Top* (length 256 bytes)
- `PrtQueueNBC` - Dynamic Hash-based Character Priority Queue with *New on Bottom* (length 256 bytes)
- `PrtQueueNTN` - Dynamic Hash-based Numeric Priority Queue with *New on Top*
- `PrtQueueNBN` - Dynamic Hash-based Numeric Priority Queue with *New on Bottom*
- `Bitmap32` - Dynamic Function Bitmap on 32 bit
- `Bitmap52` - Dynamic Function Bitmap on 52 bit

The `outlib=` option is set to `work.DFAfcmp.package`. The `cmplib=` option is updated automatically.

---

*//*** HELP END ***/

PROC FCMP outlib = work.DFAfcmp.package;

/* Create Simple Immutable Dynamic Function Array */
%createDFArray(SmpArray, simple=1, resizefactor=0, header=0);

/* Create Simple Mutable Dynamic Function Array */
%createDFArray(SmpMtbArray, simple=1, resizefactor=4999, header=0);

/* Create Searchable Immutable Dynamic Function Array */
%createDFArray(SrchArray, header=0);

/* Create Searchable Mutable Dynamic Function Array */
%createDFArray(SrchMtbArray, resizefactor=4999, header=0);

/* Create Dynamic Hash-based Character Function Array */
%createDHArray(DynArrayC, type=$ 256, header=0, hashexp=13);

/* Create Dynamic Hash-based Character Stack */
%createDHStack(StackC, type = $ 256, header=0, hashexp=13); 

/* Create Dynamic Hash-based Numeric Stack */
%createDHStack(StackN, header=0, hashexp=13); 

/* Create Dynamic Hash-based Character Fifo */
%createDHFifo(FifoC, type = $ 256, header=0); 

/* Create Dynamic Hash-based Character Fifo */
%createDHFifo(FifoN, header=0);

/* Create Dynamic Hash-based Character Descending Ordered Stack */
%createDHOrdStack(DescStackC, type = $ 256, order=D, header=0); 

/* Create Dynamic Hash-based Character Ascending Ordered Stack */
%createDHOrdStack(AscStackC, type = $ 256, order=A, header=0); 

/* Create Dynamic Hash-based Numeric Descending Ordered Stack */
%createDHOrdStack(DescStackN, order=D, header=0); 

/* Create Dynamic Hash-based Numeric Ascending Ordered Stack */
%createDHOrdStack(AscStackN, order=A, header=0); 

/* Create Dynamic Hash-based Character Priority Queue with New on Top */
%createDHPrtQueue(PrtQueueNTC, type = $ 256, newOnTop=+, header=0);

/* Create Dynamic Hash-based Character Priority Queue with New on Bottom */
%createDHPrtQueue(PrtQueueNBC, type = $ 256, newOnTop=-, header=0);

/* Create Dynamic Hash-based Numeric Priority Queue with New on Top */
%createDHPrtQueue(PrtQueueNTN, newOnTop=+, header=0);

/* Create Dynamic Hash-based Numeric Priority Queue with New on Bottom */
%createDHPrtQueue(PrtQueueNBN, newOnTop=-, header=0);

/* Create Dynamic Function Bitmap on 32 bit */
%createDFBitmap(Bitmap32, type=32, header=0);

/* Create Dynamic Function Bitmap on 52 bit */
%createDFBitmap(Bitmap52, type=52, header=0);

RUN;

/*
options APPEND=(cmplib = WORK.DFAfcmp) ;
%put NOTE:[CMPLIB] %sysfunc(getoption(cmplib));
*/
/**/
