/*** HELP START ***//*
 
## >>> `generateArrays` clean: <<< <a name="createdhprtqueue-clean"></a> #######################
 
The generateArrays clean file clears the list of automatically generated examples of functions
emulating data structures provided in the `generatearrays.sas` exec file.

The `cmplib=` option is updated automatically.

---

*//*** HELP END ***/

Proc FCMP 
  /*inlib = work.DFAfcmp*/
  outlib = work.DFAfcmp.package
;
/* Remove Simple Immutable Dynamic Function Array */
DELETESUBR SmpArray;

/* Remove Simple Mutable Dynamic Function Array */
DELETESUBR SmpMtbArray;

/* Remove Searchable Immutable Dynamic Function Array */
DELETESUBR SrchArray;

/* Remove Searchable Mutable Dynamic Function Array */
DELETESUBR SrchMtbArray;

/* Remove Dynamic Hash-based Character Function Array */
DELETESUBR DynArrayC;

/* Remove Dynamic Hash-based Character Stack */
DELETESUBR StackC; 

/* Remove Dynamic Hash-based Numeric Stack */
DELETESUBR StackN; 

/* Remove Dynamic Hash-based Character Fifo */
DELETESUBR FifoC; 

/* Remove Dynamic Hash-based Character Fifo */
DELETESUBR FifoN;

/* Remove Dynamic Hash-based Character Descending Ordered Stack */
DELETESUBR DescStackC; 

/* Remove Dynamic Hash-based Character Ascending Ordered Stack */
DELETESUBR AscStackC; 

/* Remove Dynamic Hash-based Numeric Descending Ordered Stack */
DELETESUBR DescStackN; 

/* Remove Dynamic Hash-based Numeric Ascending Ordered Stack */
DELETESUBR AscStackN; 

/* Remove Dynamic Hash-based Character Priority Queue with New on Top */
DELETESUBR PrtQueueNTC;

/* Remove Dynamic Hash-based Character Priority Queue with New on Bottom */
DELETESUBR PrtQueueNBC;

/* Remove Dynamic Hash-based Numeric Priority Queue with New on Top */
DELETESUBR PrtQueueNTN;

/* Remove Dynamic Hash-based Numeric Priority Queue with New on Bottom */
DELETESUBR PrtQueueNBN;

/* Remove Dynamic Function Bitmap on 32 bit */
DELETESUBR Bitmap32;

/* Remove Dynamic Function Bitmap on 52 bit */
DELETESUBR Bitmap52;

run;
quit;

/*
%put NOTE:[CMPLIB] %sysfunc(getoption(cmplib));
options cmplib = (%unquote(%sysfunc(tranwrd(%lowcase(%sysfunc(getoption(cmplib))), work.dfafcmp, %str()))));
options cmplib = (%unquote(%sysfunc(compress(%sysfunc(getoption(cmplib)),%str(()) ))));
%put NOTE:[CMPLIB] %sysfunc(getoption(cmplib));
*/
 
/**/
