filename P1B01408 list;

%put NOTE: Unloading package DFA, version 0.5.7, license MIT;
%put NOTE- *** START ***;

%put NOTE- Code of type clean generated from the file "generatearrays.sas" will be executed;
%put NOTE- ;

%put NOTE- Executing the following code: ;
%put NOTE- *****************************;
data _null_;
  infile P1B01408(_008_clean.generatearrays.sas) lrecl=32767;
  input;
  putlog "*> " _infile_;
run;

%put NOTE- *****************************;
%put NOTE- ;
%include P1B01408(_008_clean.generatearrays.sas) / nosource2;

proc sql;
  create table WORK._%sysfunc(datetime(), hex16.)_ as
  select memname, objname, objtype
  from dictionary.catalogs
  where 
  (
   objname in ("*"
   ,'DFAIML'
   ,'DFACASLUDF'

   %put NOTE- Element of type macro generated from the file "createdfarray.sas" will be deleted;
   %put NOTE- ;
   ,"CREATEDFARRAY                   "

   %put NOTE- Element of type macro generated from the file "createdharray.sas" will be deleted;
   %put NOTE- ;
   ,"CREATEDHARRAY                   "

   %put NOTE- Element of type macro generated from the file "createdhfifo.sas" will be deleted;
   %put NOTE- ;
   ,"CREATEDHFIFO                    "

   %put NOTE- Element of type macro generated from the file "createdhordstack.sas" will be deleted;
   %put NOTE- ;
   ,"CREATEDHORDSTACK                "

   %put NOTE- Element of type macro generated from the file "createdhprtqueue.sas" will be deleted;
   %put NOTE- ;
   ,"CREATEDHPRTQUEUE                "

   %put NOTE- Element of type macro generated from the file "createdhstack.sas" will be deleted;
   %put NOTE- ;
   ,"CREATEDHSTACK                   "

   %put NOTE- Element of type macro generated from the file "createdfbitmap.sas" will be deleted;
   %put NOTE- ;
   ,"CREATEDFBITMAP                  "

  )
  and objtype = "MACRO"
  and libname  = "WORK"
  )
  or
  (
   objname in ("*"

  )
  and objtype in ("FORMAT" "FORMATC" "INFMT" "INFMTC")
  and libname  = "WORK"
  and memname = 'DFAFORMAT'
  )
  order by objtype, memname, objname
  ;
quit;
data _null_;
  do until(last.memname);
    set WORK._last_;
    by objtype memname;
    if first.memname then call execute("proc catalog cat = work." !! strip(memname) !! " force;");
    call execute("delete " !! strip(objname) !! " /  et =" !! objtype !! "; run;");
  end;
  call execute("quit;");
run;
proc delete data = WORK._last_;
run;
%put NOTE- Element of type proto generated from the file "bit64andprotodfa.sas" will be deleted;
%put NOTE- ;

%put NOTE- Element of type proto generated from the file "bit64orprotodfa.sas" will be deleted;
%put NOTE- ;

proc delete data = work.dfaproto;
run;

options cmplib = (%unquote(%sysfunc(tranwrd(
%lowcase(%sysfunc(getoption(cmplib)))
,%str(work.dfaproto), %str() ))));
options cmplib = (%unquote(%sysfunc(compress(
%sysfunc(getoption(cmplib))
,%str(()) ))));
%put; %put NOTE:[CMPLIB] %sysfunc(getoption(cmplib));

proc fcmp outlib = work.dfafcmp.package;
%put NOTE- Element of type functions generated from the file "bit64anddfa.sas" will be deleted;
%put NOTE- ;
deletefunc bit64anddfa ;

%put NOTE- Element of type functions generated from the file "bit64ordfa.sas" will be deleted;
%put NOTE- ;
deletefunc bit64ordfa ;

run;

options cmplib = (%unquote(%sysfunc(tranwrd(
%lowcase(%sysfunc(getoption(cmplib)))
,%str(work.dfafcmp), %str() ))));
options cmplib = (%unquote(%sysfunc(compress(
%sysfunc(getoption(cmplib))
,%str(()) ))));
%put; %put NOTE:[CMPLIB] %sysfunc(getoption(cmplib));

proc sql noprint;
quit;

run;

data _null_ ;                                                                                        
  length SYSloadedPackages $ 32767;                                                                   
  if SYMEXIST("SYSloadedPackages") = 1 and SYMGLOBL("SYSloadedPackages") = 1 then                     
    do;                                                                                               
      do until(EOF);                                                                                  
        set sashelp.vmacro(where=(scope="GLOBAL" and name="SYSLOADEDPACKAGES")) end=EOF;              
        substr(SYSloadedPackages, 1+offset, 200) = value;                                             
      end;                                                                                            
      SYSloadedPackages = cats("#", translate(strip(SYSloadedPackages), "#", " "), "#");              
      if INDEX(lowcase(SYSloadedPackages), '#dfa(0.5.7)#') > 0 then    
         do;                                                                                          
          SYSloadedPackages = tranwrd(SYSloadedPackages, '#DFA(0.5.7)#', '##');  
          SYSloadedPackages = compbl(translate(SYSloadedPackages, " ", "#"));                         
          call symputX("SYSloadedPackages", SYSloadedPackages, "G");                                  
          put "NOTE: " SYSloadedPackages = ;                                                          
         end ;                                                                                        
    end;                                                                                              
  stop;                                                                                               
run;                                                                                                  

%put NOTE: Unloading package DFA, version 0.5.7, license MIT;
%put NOTE- *** END ***;
%put NOTE- ;

/* unload.sas end */
