filename PC6016FF list;

%put NOTE: Unloading package dynMacroArray, version 0.2.7, license MIT;
%put NOTE- *** START ***;

proc sql;
  create table WORK._%sysfunc(datetime(), hex16.)_ as
  select memname, objname, objtype
  from dictionary.catalogs
  where 
  (
   objname in ("*"
   ,'DYNMACROARRAYIML'
   ,'DYNMACROARRAYCASLUDF'

   %put NOTE- Element of type macro generated from the file "appendbefore.sas" will be deleted;
   %put NOTE- ;
   ,"APPENDBEFORE                    "

   %put NOTE- Element of type macro generated from the file "appendto.sas" will be deleted;
   %put NOTE- ;
   ,"APPENDTO                        "

   %put NOTE- Element of type macro generated from the file "dynarray.sas" will be deleted;
   %put NOTE- ;
   ,"DYNARRAY                        "

   %put NOTE- Element of type macro generated from the file "getval.sas" will be deleted;
   %put NOTE- ;
   ,"GETVAL                          "

   %put NOTE- Element of type macro generated from the file "loopend.sas" will be deleted;
   %put NOTE- ;
   ,"LOOPEND                         "

   %put NOTE- Element of type macro generated from the file "loopover.sas" will be deleted;
   %put NOTE- ;
   ,"LOOPOVER                        "

   %put NOTE- Element of type macro generated from the file "putval.sas" will be deleted;
   %put NOTE- ;
   ,"PUTVAL                          "

   %put NOTE- Element of type macro generated from the file "rangeof.sas" will be deleted;
   %put NOTE- ;
   ,"RANGEOF                         "

  )
  and objtype = "MACRO"
  and libname  = "WORK"
  )
  or
  (
   objname in ("*"

  )
  and objtype in ("FORMAT" "FORMATC" "INFMT" "INFMTC")
  and libname  = "WORK"
  and memname = 'DYNMACROARRAYFORMAT'
  )
  order by objtype, memname, objname
  ;
quit;
data _null_;
  do until(last.memname);
    set WORK._last_;
    by objtype memname;
    if first.memname then call execute("proc catalog cat = work." !! strip(memname) !! " force;");
    call execute("delete " !! strip(objname) !! " /  et =" !! objtype !! "; run;");
  end;
  call execute("quit;");
run;
proc delete data = WORK._last_;
run;
proc fcmp outlib = work.dynmacroarrayfcmp.package;
run;

proc sql noprint;
quit;

run;

data _null_ ;                                                                                        
  length SYSloadedPackages $ 32767;                                                                   
  if SYMEXIST("SYSloadedPackages") = 1 and SYMGLOBL("SYSloadedPackages") = 1 then                     
    do;                                                                                               
      do until(EOF);                                                                                  
        set sashelp.vmacro(where=(scope="GLOBAL" and name="SYSLOADEDPACKAGES")) end=EOF;              
        substr(SYSloadedPackages, 1+offset, 200) = value;                                             
      end;                                                                                            
      SYSloadedPackages = cats("#", translate(strip(SYSloadedPackages), "#", " "), "#");              
      if INDEX(lowcase(SYSloadedPackages), '#dynmacroarray(0.2.7)#') > 0 then    
         do;                                                                                          
          SYSloadedPackages = tranwrd(SYSloadedPackages, '#dynMacroArray(0.2.7)#', '##');  
          SYSloadedPackages = compbl(translate(SYSloadedPackages, " ", "#"));                         
          call symputX("SYSloadedPackages", SYSloadedPackages, "G");                                  
          put "NOTE: " SYSloadedPackages = ;                                                          
         end ;                                                                                        
    end;                                                                                              
  stop;                                                                                               
run;                                                                                                  

%put NOTE: Unloading package dynMacroArray, version 0.2.7, license MIT;
%put NOTE- *** END ***;
%put NOTE- ;

/* unload.sas end */
