/*** HELP START ***//*
 
## >>> `%GSMpck_makeFCMPcode()` macro: <<< <a name="GSMpck-makeFCMPcode-macro"></a> #######################

The `%GSMpck_makeFCMPcode()` macro is an internal macro of 
the **GSM** (a.k.a. *Generate Secure Macros*) package. 

It executes a process of converting 
a macro provided by the user into
a Proc FCMP function. 

Since encrypted code is stored in a SAS dataset it has
no limitation in sharing between operating systems (like catalogs have).

*Limitation:* Single macro file cannot be longer than 32760 bytes.

### SYNTAX: ###################################################################

The basic syntax is the following, the `<...>` means optional parameters:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
%GSMpck_makeFCMPcode( 
   path
  ,number
 <,outlib=work.generateMacros.secure>
 <,source2=>
 <,fileNameCode=FNC>
 <,secret=123456789>
 <,lineEnd=0A>
)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

**Arguments description**:

1. `path`         - *Required*, indicates a directory which contains files with macros.
                    Only files with `sas` extension are used.

2. `number`       - *Required*, a sequential number.


* `cmplib=`       - *Optional*, the default value is `work.generateMacros`. 
                    Names the dataset which will contain generated functions. 

* `source2=`      - *Optional*, the default value is null. 
                    Indicate if `%includ`-ed files are printed out.
                    Any value other than null enables printing.

* `fileNameCode=` - *Optional*, the default value is `FNC`.
                    Internal fileref.

* `secret=`       - *Optional*, internal, the default value is `1234567890`.
                    Alphanumerical constant required to execute the `resolve()`
                    function. User who do not know the value will not be able
                    to run the `_maxro_XX_()` function.

* `lineEnd=`      - *Optional*, the default value is `0D0A`, indicates which of:
                    line feed, carriage return, or both, or a space be inserted 
                    at the end of line in the intermediate code file that is generated.
                    Value has to be hexadecimal code (_NOT_ null),
                    since the value is resolved as `"&lineEnd."x`, so use e.g.
                    `0A` for line feed, `0D` for carriage return, 
                    `0D0A` for both, and `20` for space.

* `trim=`          - *Deprecated*, the default value is `0`.
                     *Kept for backward compatibility.*

---

*//*** HELP END ***/


%macro GSMpck_makeFCMPcode( /*gsmpck_makefcmpcode.sas*/
  path
, number
, trim=0 /*0,1,2*/
, outlib=work.generateMacros.secure
, source2=
, fileNameCode=FNC
, secret=1234567890
, lineEnd=0D0A
);
%put /#**********************************************************#/ ;
%local macroFilenameIn macroFilenameOut runFunction;
%let macroFilenameIn  = _%sysfunc(datetime(), hex6.)i;
%let macroFilenameOut = _%sysfunc(datetime(), hex6.)o;
%let runFunction      = rc = _macro_&number._("&secret.") ; /* 1) Remember about semicolon.
                                                               2) Double quotes are ok
                                                                  because the runFunction is
                                                                  called by symget().
                                                               */

filename &macroFilenameIn.  "&path.";
filename &macroFilenameOut. "%sysfunc(pathname(work))/&macroFilenameOut._TEMP_CODE_FILE" lrecl=1 recfm=n; /*32767;*/

data _tmp_file_&macroFilenameIn._;
  infile &macroFilenameIn. eof=END recfm=n;
  input x $ char1.;
  output;
  if x = "'" then output; /* make all single quotes doubled */
  length line0 $ 2048 tst $ 3; retain line0 "" tst "***";
  if x in ('0a'x '0d'x) then
    do;
      END:
      if n then
        do;
          if symget("source2") ne " " then
            put n @5 "*" line0 $varying2048. n "*";
          test4SECURE + prxmatch('/(^|\s|\/)secure($|;|\s)/i', line0);
          /*output;*/
        end;
      line0 = "";
      n = 0;
    end;
  else
    do;
      n + 1;
      substr(line0,n,1) = x;
      tst = substr(tst,2) !! x;
    end;
  if tst = ("/" !! "*" !! '%') then
    do;
      put 'NOTE: Your code contains consecutive: /*% sequence.'
        / 'NOTE- Consider adding a space between * and %.'
        /* / 'WARNING- The code will NOT be included.'*/
        ;
      /*call symputX("runFunction", "", "L");*/
    end;
  keep x test4SECURE /*line0 n */ ;
run;


data _null_;
  set _tmp_file_&macroFilenameIn._ end=end;
  file &macroFilenameOut.;

  /*input;*/
  /*length line $ 32767;*/
  /*retain trim &trim. lineEnd;*/

  if _N_ = 1 then
    do;
      /*if symget('lineEnd') ne " " 
        then lineEnd = " !! '&lineEnd.'x !! ";
        else lineEnd = " !! ";*/

      put "options noquotelenmax; " "&lineEnd."x;
      put "options cmplib = _null_; " "&lineEnd."x;
      put "proc fcmp outlib = &outlib. &ENCRYPT. ; " "&lineEnd."x;      
      put "function _macro_&number._(secret $) $; " "&lineEnd."x;
      put "if secret = '&secret.' then " "&lineEnd."x;
      put "rc = RESOLVE( '";
    end;

  /*substr(line0,1,n)*/
  /*
  select(trim);
    when (0)  line = quote(      substr(line0,1,n) , "'") !! lineEnd;
    when (1)  line = quote( trim(substr(line0,1,n)), "'") !! lineEnd;
    when (2)  line = quote(strip(substr(line0,1,n)), "'") !! lineEnd;
    otherwise line = quote(      substr(line0,1,n) , "'") !! lineEnd;
  end;
  */
  
  size + 1;
  /*size + (lengthn(line)-5);*/
  /*size + n;*/
  if size >= 32760 then
    do;
      putlog "ERROR: Up to this point the total code size in bytes exceeds 32760.";
      putlog "ERROR- The RESOLVE() function will not be able to execute it properly.";
      putlog "ERROR-";       
      end = 2;
      call symputX("runFunction", "", "L");
      put ';%mend;''); rc = "ERROR- ERROR!"; err=length( '/; /*keep it this way*/
    end;   
  else
    do;
      select(x);
        when('0d'x) put "' !! '" x hex2. "'x !! '" @@;       
        when('0a'x) put "' !! '" x hex2. "'x !!" "&lineEnd."x " '" @@;       
        otherwise put x char1. @@;
      end;
    end;

  if end then
    do;
      put "' ); " "&lineEnd."x;
      put "return (rc); " "&lineEnd."x;
      put "endsub; " "&lineEnd."x;
      put "run; " "&lineEnd."x;
      length quotelenmax $ 50 cmplib $ 5000;
      quotelenmax = getoption("quotelenmax");
      cmplib      = getoption("cmplib", "keyword");
      put "options " quotelenmax "; " "&lineEnd."x;
      put "options " cmplib "; " "&lineEnd."x;
      if end = 1 then
        do;
          putlog "WARNING- Total code size in bytes: " size;
          putlog "WARNING-";
        end;
      if test4SECURE = 0 then
        do;
          putlog "ERROR: Did not match the SECURE keyword in the macro definition.";
          putlog "ERROR-";
        end;
      stop;
    end;
run;

proc delete data = _tmp_file_&macroFilenameIn._;
run;

/*
data _null_;
  infile &macroFilenameOut.;
  input;
  putlog _infile_;
run;
*/
%if %superq(runFunction) ne %then
%do;
  filename &macroFilenameOut. "%sysfunc(pathname(work))/&macroFilenameOut._TEMP_CODE_FILE" lrecl=32767;
  %include &macroFilenameOut. / &source2.;

  data _null_;
    file &fileNameCode. mod;
    length runFunction $ 128;
    runFunction = symget("runFunction");
    put " " runFunction "; ";
    put " if rc ne '' then do; "
      / "  put 'WARNING: Macro &number. rc =' rc; "
      / "  put 'WARNING: Return code was not null!'; "
      / "  put 'WARNING: The provided code may not be a macro.'; "
      / " end; ";
  run;
%end;

data _null_;
  rc_fd = fdelete("&macroFilenameOut.");
  putlog rc_fd=;
run;

filename &macroFilenameIn.  clear;
filename &macroFilenameOut. clear;
%put /#**********************************************************#/ ;
%mend GSMpck_makeFCMPcode;

