/* This is the description file for the package.         */
/* The colon (:) is a field separator and is restricted */
/* in lines of the header part.                          */

/* **HEADER** */
Type: Package                                             
Package: GSM                                              
Title: Generate Secure Macros - to keep your code secret
Version: 0.22.1                                     
Author: Bartosz Jablonski (yabwon@gmail.com)     
Maintainer: Bartosz Jablonski (yabwon@gmail.com) 
License: MIT
Encoding: UTF8                                            

Required: "Base SAS Software"

/* **DESCRIPTION** */
/* All the text below will be used in help */
DESCRIPTION START:

# The GSM package [ver. 0.22.1] <a name="gsm-package"></a> ###############################################

The **GSM** (a.k.a. *Generate Secure Macros*) package allows
to create secured macros stored in SAS Proc FCMP functions.
The dataset with functions can be shared and allows to generate 
macros without showing their code.

[Recording of presentation with "how it works" description (in Polish)](https://www.youtube.com/watch?v=LtaWPe2sgRY&t=1s "YouTube").

[The WUSS 2023 Conference article describing the idea](https://www.wuss.org/wuss-2023-conference-proceedings/ "Article about the idea GSM")

The GSM package is basically an automated version of the following:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
proc fcmp outlib = work.gsm.secure ENCRYPT;
  function generateMacro() $;
    rc = RESOLVE('
      %macro secretMacro(x) / SECURE;
        data test;
         a = "&x.";
        run;
      %mend;
    ');
    return (rc);
  endsub;
run;

/* share work.gsm dataset */
options cmplib = work.gsm;
data _null_;
  rc = generateMacro();
  put rc=;
run;

/* enjoy */
%secretMacro(42)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
See examples for more details.


*How to use it:* 
 - Copy all files with your secured macros code into a directory. 
   Best approach is to have one file for one macro.
 - Copy a path to the directory.
 - Run the following code:
   ```
   %GSM(<the path to directory>, cmplib=<name of the dataset>)
   ```
 - Share generated `ZIP` file (unzip and run the code).

*Limitations:* 
 Single macro file cannot be longer than 32760 bytes.

---
DESCRIPTION END:
