
/*==============================================================================================*


                                       WUSS 2023 - Paper 189                                


           _____          _____    _____          _        _    _       _     _             
          / ____)  /\    / ____)  / ____)        | |      | |  | |_    | |   | |            
   __ _  ( (___   /  \  ( (___   / /     ___   __| | ___  | |__| (_) __| | __| | ___ _ __   
  / _` |  \___ \ / /\ \  \___ \ ( (     / _ \ / _` |/ _ \ |  __  | |/ _` |/ _` |/ _ \ '_ \  
 ( (_| |  ____) / ____ \ ____) ) \ \___( (_) ( (_| |  __/ | |  | | | (_| | (_| |  __/ | | \ 
  \__,_| (_____/_/    \_\_____/   \_____\___/ \__,_|\___| |_|  |_|_|\__,_|\__,_|\___|_| |_| 
                                                                                            

                           _____  _                  _____         _     _                 
                 _        |  __ \| |      _         / ____)_      | |   | |                
                (_)_ __   | |__) ) | __ _(_)_ __   ( (___ (_) __ _| |__ | |_               
                | | '_ \  |  ___/| |/ _` | | '_ \   \___ \| |/ _` | '_ \| __|              
                | | | | \ | |    | | (_| | | | | \  ____) | | (_| | | | | |_               
                |_|_| |_| |_|    |_|\__,_|_|_| |_| (_____/|_|\__, |_| |_|\__)              
                                                              __/ |                        
                                                             |___/                         

                                      by Bartosz Jablonski
                                     yabwon (@) gmail . com


 *==============================================================================================*/

/*

This is the main code used during presentation of the article.

*/


/* Macros */


%macro notSecretMacro(question) ;
  data _null_;
    x = 42;
    put "The answer for &question. is: " x;
  run;
%mend;













options mprint mlogic symbolgen;
%notSecretMacro('question about life, universe, and all the rest')

















filename ns catalog 'work.sasmacr.notSecretMacro.macro';
data _null_;
  infile ns;
  input;
  put _INFILE_;
run;
















%macro secretMacro(question) / SECURE ;
  data _null_;
    x = rank("*");
    put "The answer for &question. is: " x;
  run;
%mend;

options mprint mlogic symbolgen;
%secretMacro('question about life, universe, and all the rest')











filename s catalog 'work.sasmacr.secretMacro.macro';
data _null_;
  infile s;
  input;
  put _INFILE_;
run;

%put %secretMacro('question about life, universe, and all the rest');


/*
data _null_;
  rc = resolve('%secretMacro("question about life, universe, and all the rest")');
  put rc=;
run;
*/





/* But... :-/

libname WinOS "C:\TEST";
options mstored sasmstore=WinOS;

%macro secretMacro(question) / STORE SECURE ;
  data _null_;
    x = rank("*");
    put "The answer for &question. is: " x;
  run;
%mend;



libname LinuxOS "/home/&sysuserid./SAS/TEST";
options mstored sasmstore=LinuxOS;
%secretMacro(’question about life, universe, and all the rest’)

*/













/* Functions */


proc FCMP outlib=work.notSecret.p;
  function notSecret(question $);
    x = 42;
    return(x);
  endsub;
run;
proc print data=work.notSecret noobs;
  where NValue;
  var Type Subtype Name Value;
run;













proc FCMP outlib=work.secret.p ENCRYPT ;
  function secret(question $);
    x = rank("*");
    return(x);
  endsub;
run;
proc print data=work.secret noobs;
  where NValue;
  var Type Subtype Name Value;
run;
















options cmplib = (work.secret work.notSecret);

data _null_;
  rcDS = secret('question about life, universe, and all the rest');
  put rcDS=;
run;

proc sql;
select distinct
  secret('question about life, universe, and all the rest') as rcSQL
from 
  sashelp.class(obs=1)
; 
quit;


title "Not secret";
proc FCMP LISTSOURCE LISTFUNCS LISTCODE;
  LISTFUNC notSecret;
run;

title "Secret";
proc FCMP LISTSOURCE LISTFUNCS LISTCODE;
  LISTFUNC secret;
run;

title;

















/* Challenge */


proc FCMP outlib = work.secretFunction.p ENCRYPT ;
  function secretFunction();
      %macro littleSecretMacro(question) / SECURE ;
        data _null_;
          x = rank("*");
          put "Dear user, the answer for &question. is: " x;
        run;
      %mend;
  endsub;
run;

proc print data=work.secretFunction;
  where NValue;
run;


























/* Resolve() function */

%let A0=1 2 3;
%let B0=4 5 6;

%macro C1();
  data C1;
    do i = 1 to 3;
      put i=;
    end;
  run;
%mend C1;

data _null_;
  rc1 = resolve('&A0. &B0.');
  put rc1=;

  rc2 = resolve('%C1()');
  put rc2=;
run;


data _null_;
  rc3 = resolve('
    %macro D2();
      data D2;
        do i = 1 to 3;
          put i=;
        end;
      run;
    %mend D2;
');
  put rc3=;
run;

options mprint;
%D2()


















/* The solution */


proc FCMP outlib = work.gsm.secure ENCRYPT ;
  function generateMacro() $;
    rc = RESOLVE('
      %macro ultimateSecretMacro(question) / SECURE ;
        data _null_;
          x = rank("*");
          put "Dear user, the answer for &question. is: " x;
          put "So long, and thanks for all the fish!";
        run;
      %mend;
    ');
    return (rc);
  endsub;
run;

proc print data=work.gsm noobs;
  where NValue;
  var Type Subtype Name Value;
run;















%ultimateSecretMacro('question about life, universe, and all the rest')














options cmplib=work.gsm;

data _null_;
  rc = generateMacro();
run;



/* test 1 */
options mprint mlogic symbolgen ls=max ps=max;

%ultimateSecretMacro('question about life, universe, and all the rest')

options nomprint nomlogic nosymbolgen;








/* test 2 */
filename usm catalog 'work.sasmacr.ultimateSecretMacro.macro';
data _null_;
  infile usm;
  input;
  put _INFILE_;
run;










/* The End ??? */





/* test 3 */
%macro unhide()/parmbuff;
  %put ###&syspbuff###;
%mend unhide;


%unhide(Life is like a box of chocolates, you newer know what you are going to get.)



options mprint mlogic symbolgen ls=120 ps=max;

%unhide(%ultimateSecretMacro('question about life, universe, and all the rest'))

options nomprint nomlogic nosymbolgen;




















/* The solution - SECURE limitation fix */

proc FCMP outlib = work.gsm.secure ENCRYPT ;
 function generateFinalMacro() $;
  rc = RESOLVE('
   %macro finalUltimateSecretMacro(question) / SECURE ;

    %local rc;
    %let rc = %sysfunc(doSubL(%str(
     options ps=min nonotes nomprint nosymbolgen nomlogic nosource nosource2;

     data _null_;
      x = rank("*");
      put "Dear user, the answer for &question. is: " x;
      put "So long, and thanks for all the fish!";
     run;

    )));

   %mend;
  ');
  return (rc);
 endsub;
run;

proc print data=work.gsm;
  where NValue;
  var _key_ Name Value;
run;





data _null_;
  rc = generateFinalMacro();
run;


options mprint mlogic symbolgen ls=max ps=max;

%finalUltimateSecretMacro('question about life, universe, and all the rest')

options nomprint nomlogic nosymbolgen;


filename fusm catalog 'work.sasmacr.finalUltimateSecretMacro.macro';
data _null_;
  infile fusm;
  input;
  put _INFILE_;
run;


options mprint mlogic symbolgen ls=max ps=max;

%unhide(%finalUltimateSecretMacro('question about life, universe, and all the rest'))

options nomprint nomlogic nosymbolgen;









/*
options dlcreatedir;
libname path "R:\WUSS2023\";
libname path "R:\WUSS2023\path2files";
options nodlcreatedir;
*/




/* installation and running of the GSM package */
/*

filename packages "R:\WUSS2023";

filename SPFinit 
 url "https://bit.ly/SPFinit";
%include SPFinit;

*/

/* 

%installPackage(SPFinit)       
%include packages(SPFinit.sas); 

*/

/*

%installPackage(GSM) 
%loadPackage(GSM)    

*/















/* some example macros */
/*

filename path "R:\WUSS2023\path2files";

data _null_;
  file path(f1.sas);
  input;
  put _infile_;
cards4;
%* f1.sas ;
%macro abc(x) / SECURE;
  data test1;
    do i = 1 to &x.;
      put i=;
    end;
  run;
%mend;
;;;;
run;

data _null_;
  file path(f2.sas);
  input;
  put _infile_;
cards4;
%* f2.sas ;
%macro xyz(x) / SECURE;
  %do i = 1 %to &x.;
    %put &=i.;
  %end;
%mend;
;;;;
run;

data _null_;
  file path(f3.sas);
  input;
  put _infile_;
cards4;
%* f3.sas ;
%macro efg(x) / SECURE;
  %local rc;
  %let rc = %sysfunc(doSubL(%str(
    options ps=min nonotes nomprint nosymbolgen nomlogic nosource nosource2;
    data test2;
      do i = 1 to &x.;
        put "doSubL() " i=;
      end;
    run;
  )));
%mend;
;;;;
run;


*/



















options nomprint;
resetline;

%GSM(R:\WUSS2023\path2files, cmplib=path.myMacros)






title "Generated functions";
proc print data=path.myMacros;
  where NValue;
  var _Key_ Subtype Name Value;
run;













/* test on Linux machine*/
%abc(3)
%xyz(5)
%efg(7)

libname path "/home/&sysuserid./SAS/gsmtest";

/* extract the contents (requires XCMD enabled) */
filename x pipe "cd /home/&sysuserid./SAS/gsmtest/; unzip ./mymacros.zip";
data _null_;
   infile x;
   input;
   put _infile_;
run;


options cmplib=path.myMacros;

data _null_;
  rc = generateMacros();
run;



options mprint;
%abc(3)
%xyz(5)
%efg(7)


filename s catalog 'work.sasmacr.abc.macro';
data _null_;
  infile s;
  input;
  put _INFILE_;
run;



%macro unhide()/parmbuff;
  %put ###&syspbuff###;
%mend unhide;

options mprint mlogic symbolgen ls=120 ps=max;

%unhide(%abc(3))

%unhide(%xyz(5))

%unhide(%efg(7))

options nomprint nomlogic nosymbolgen;




/* ++++++++++++++++++++++++++++ */
/* Good programming practice!!! */


%finalUltimateSecretMacro(%nrstr(%"; put 'EXPLOIT'; run; data Unwanted_dataset; run;) )



/* The solution - SECURE limitation fix + GPP */

proc FCMP outlib = work.gsm.secure ENCRYPT ;
 function generateFinalMacroGPP() $;
  rc = RESOLVE('
   %macro finalUltimateSecretMacroGPP(question) / SECURE ;

    %local rc;
    %let rc = %sysfunc(doSubL(%str(
     options ps=min nonotes nomprint nosymbolgen nomlogic nosource nosource2;

     data _null_;
      x = rank("*");
      question = quote(symget("question"));
      put "Dear user, the answer for " question " is: " x;
      put "So long, and thanks for all the fish!";
     run;

    )));

   %mend;
  ');
  return (rc);
 endsub;
run;

proc print data=work.gsm;
  where NValue;
  var _key_ Name Value;
run;


data _null_;
  rc = generateFinalMacroGPP();
run;


%finalUltimateSecretMacroGPP(%nrstr(%"; put 'EXPLOIT'; run; data Unwanted_dataset; run;) )
