/*==============================================================================================*


                                       WUSS 2023 - Paper 189                                


           _____          _____    _____          _        _    _       _     _             
          / ____)  /\    / ____)  / ____)        | |      | |  | |_    | |   | |            
   __ _  ( (___   /  \  ( (___   / /     ___   __| | ___  | |__| (_) __| | __| | ___ _ __   
  / _` |  \___ \ / /\ \  \___ \ ( (     / _ \ / _` |/ _ \ |  __  | |/ _` |/ _` |/ _ \ '_ \  
 ( (_| |  ____) / ____ \ ____) ) \ \___( (_) ( (_| |  __/ | |  | | | (_| | (_| |  __/ | | \ 
  \__,_| (_____/_/    \_\_____/   \_____\___/ \__,_|\___| |_|  |_|_|\__,_|\__,_|\___|_| |_| 
                                                                                            

                           _____  _                  _____         _     _                 
                 _        |  __ \| |      _         / ____)_      | |   | |                
                (_)_ __   | |__) ) | __ _(_)_ __   ( (___ (_) __ _| |__ | |_               
                | | '_ \  |  ___/| |/ _` | | '_ \   \___ \| |/ _` | '_ \| __|              
                | | | | \ | |    | | (_| | | | | \  ____) | | (_| | | | | |_               
                |_|_| |_| |_|    |_|\__,_|_|_| |_| (_____/|_|\__, |_| |_|\__)              
                                                              __/ |                        
                                                             |___/                         

                                      by Bartosz Jablonski
                                     yabwon (@) gmail . com


 *==============================================================================================*/

/*

This is a supplementary material which extends Appendix C.

*/





/* conditional execution of 4gl code */

/* IF-THEN-ELSE  inside %str() will not work... */
%macro secret1(x) / secure;
%local rc;
%let rc = %sysfunc(doSubL(%str(
  %if %sysevalf(&x. > 0) %then
    %do;
      data red1;
        x = &x.;
        text = "X is greater than 0";
      run;
    %end;
  %else
    %do;
      data blue1;
        x = &x.;
        text = "X is NOT greater than 0";
      run;
    %end;
  proc print;
  run;
)));
%mend secret1;

%secret1(17)
%secret1(-42)



/* ...but with %nrstr(), it will. */


/* working option number 0 */

%macro secret1(x) / secure;
%local rc;
%let rc = %sysfunc(doSubL(%nrstr(
  options ps=min nomprint nomlogic nosymbolgen;
  %if %sysevalf(&x. > 0) %then
    %do;
      data red1;
        x = &x.;
        text = "X is greater than 0";
      run;
    %end;
  %else
    %do;
      data blue1;
        x = &x.;
        text = "X is NOT greater than 0";
      run;
    %end;
  proc print;
  run;
)));
%mend secret1;


/* test */
%macro unhide()/parmbuff;
  %put ###&syspbuff###;
%mend unhide;

options mprint mlogic symbolgen ls=120 ps=max;

%secret1(17)
%secret1(-42)

options nomprint nomlogic nosymbolgen;


/* but nested IF-THEN-ELSE this will not work! */
%macro secret1(x,y) / secure;
%local rc;
%let rc = %sysfunc(doSubL(%nrstr(
  options ps=min nomprint nomlogic nosymbolgen;
  %if %sysevalf(&x. > 0) %then
    %do;
      %if %sysevalf(&y. > 0) %then
        %do;
          data red1;
            x = &x.;
            y = &y.;
            text = "X is greater than 0";
          run;
        %end;
      %else
        %do;
          data green1;
            x = &x.;
            y = &y.;
            text = "X is greater than 0";
          run;
        %end;
    %end;
  %else
    %do;
      data blue1;
        x = &x.;
        text = "X is NOT greater than 0";
      run;
    %end;
  proc print;
  run;
)));
%mend secret1;


%secret1(17,1)
%secret1(17,-1)
%secret1(-42)



/* working option number 1 */

%macro secret2(x,y) / secure;
%local rc;

%if %sysevalf(&x. > 0) %then
  %do;
    %if %sysevalf(&y. > 0) %then
      %do;
        %let rc = %sysfunc(doSubL(%str(
          data red2;
            x = &x.;
            y = &y.;
            text = "X is greater than 0";
          run;
          proc print;
          run;
        )));
    %end;
  %else
    %do;
      %let rc = %sysfunc(doSubL(%str(
          data green2;
            x = &x.;
            y = &y.;
            text = "X is greater than 0";
          run;
          proc print;
          run;
        )));
    %end;
  %end;
%else
  %do;
    %let rc = %sysfunc(doSubL(%str(
      data blue2;
        x = &x.;
        text = "X is NOT greater than 0";
      run;
      proc print;
      run;
    )));
  %end;
%mend secret2;




/* test */
%macro unhide()/parmbuff;
  %put ###&syspbuff###;
%mend unhide;

options mprint mlogic symbolgen ls=120 ps=max;

%unhide(%secret2(17,1)  )
%unhide(%secret2(-42)   )
%unhide(%secret2(0)     )
%unhide(%secret2(100,-1))

options nomprint nomlogic nosymbolgen;






/* IF-THEN-ELSE working option number 2 */

%macro secret3(x,y) / secure;
%local rc;
%let rc = %sysfunc(doSubL(

  %sysfunc(ifc(&x. > 0
    ,%sysfunc(ifc(&y. > 0
        ,%str(
          data red3;
            x = &x.;
            y = &y.;
            text = "X is greater than 0";
          run;
        )
        ,%str(
          data green3;
            x = &x.;
            y = &y.;
            text = "X is NOT greater than 0";
          run;
        )
    ))
    ,%str(
      data blue3;
        x = &x.;
        text = "X is NOT greater than 0";
      run;
    )
  ))

  %str(
    proc print;
    run;
  )

));
%mend secret3;

/* test */
%macro unhide()/parmbuff;
  %put ###&syspbuff###;
%mend unhide;

options mprint mlogic symbolgen ls=120 ps=max;

%unhide(%secret3(17,1)  )
%unhide(%secret3(-42)   )
%unhide(%secret3(0)     )
%unhide(%secret3(100,-1))

options nomprint nomlogic nosymbolgen;











/* IF-THEN-ELSE working option number 3 */



%macro iff(cond, true, false) / secure;
%put NOTE:[&sysmacroname.] START *************************;
%if %sysevalf(&cond.) %then
%do;
%put # TRUE #;
&true.
%end;
%else
%do;
%put # FALSE #;
&false.
%end;
%put NOTE:[&sysmacroname.] END ***************************;
%mend iff;

%macro secret4(x,y) / secure;
%local rc;
%let rc = %sysfunc(doSubL(
  %str(options ps=min nomlogic nosymbolgen nomprint nosource nosource2;)

  %iff(&x. > 0
    ,%iff(&y. > 0
        ,%str(
          data red3;
            x = &x.;
            y = &y.;
            text = "X and Y are greater than 0";
          run;
        )
        ,%str(
          data green3;
            x = &x.;
            y = &y.;
            text = "X is greater than 0";
          run;
        )
      )
    ,%str(
      data blue3;
        x = &x.;
        text = "X is NOT greater than 0";
      run;
    )
  )

  %str(
    proc print;
    run;
  )

));
%mend secret4;




/* test */
%macro unhide()/parmbuff;
  %put ###&syspbuff###;
%mend unhide;

options mprint mlogic symbolgen ls=120 ps=max;

%unhide(%secret4(17,1)  )
%unhide(%secret4(-42,1) )
%unhide(%secret4(0,1)   )
%unhide(%secret4(100,-1))

options nomprint nomlogic nosymbolgen;










/* looping over 4gl code */

/* this will not work! */
%macro secret1B(x) / secure;
%local rc;
%let rc = %sysfunc(doSubL(%str( /* won't work even with %nrstr(...) */
  %do i = 1 %to &x. %by 1;
    data red1;
      x = &i.;
      text = "X is greater than 0";
    run;
  %end;
)));
%mend secret1B;

%secret1B(5)






/* DO-LOOP working option number 1 */


resetline;
%macro doLoop(start, end, execute, by=1, index=i) / secure;
%put NOTE:[&sysmacroname.] START *************************;
%put NOTE- &=start. &=end. &=by. &=index.;
%do &index. = &start. %to &end. %by &by.; 
%unquote(&execute.)
%end;
%put NOTE:[&sysmacroname.] END ***************************;
%mend doLoop;


%macro secret5(color,x) / secure;
%local rc;
%let rc = %sysfunc(doSubL(%nrstr(
  options ps=min nomlogic nosymbolgen nomprint nosource nosource2;

  %doLoop(1,&x.
    ,%nrstr(
      data &color._&t.;
        x = &t.;
        text = "&color.";
      run;
    )
    ,by=2
    ,index=t
  )


)));
%mend secret5;



/* test 3 */
%macro unhide()/parmbuff;
  %put ###&syspbuff###;
%mend unhide;

options mprint mlogic symbolgen ls=120 ps=max;

%secret5(red,5)

%unhide(%secret5(green,5))

%unhide(%doLoop(1, 5, %nrstr(data blue_&t.;x = &t.;text = "X is greater than 0";run;), by=2, index=t))

options nomprint nomlogic nosymbolgen;






 /* ##################################################################################################### */



/* Example 1: Conditional loop */

resetline;
%macro secret6(x) / secure;
%local rc;
%let rc = %sysfunc(doSubL(%nrstr(
  options ps=min nomlogic nosymbolgen nomprint nosource nosource2;

    %iff(&x. < 3
      ,%doLoop(1,&x.
          ,%nrstr(
            data red_&t.;
              x = &t.;
              text = "X is greater than 0";
            run;
          )
          ,by=1
          ,index=t
       )
      ,%str(
        data blue3;
          x = &x.;
          text = "X is NOT greater than 0";
        run;
       )
    )

)));
%mend secret6;

/* test 3 */
%macro unhide()/parmbuff;
  %put ###&syspbuff###;
%mend unhide;

options mprint mlogic symbolgen ls=120 ps=max;

%unhide(%secret6(5))

%unhide(%secret6(2))

options nomprint nomlogic nosymbolgen;








/* Example 2: Loops in data step */

resetline;

data inputDS;
  call streaminit(42);
  do var = 1 to 1000;
    val = rand("normal");
    output;
  end;

  var = .;
  val = 0;
  output;
run;



%macro secret7(x) / secure;
%local rc;
%let rc = %sysfunc(doSubL(%nrstr(
  options ps=min nomlogic nosymbolgen nomprint nosource nosource2;

  data %doLoop(0,&x.-1,%nrstr( red_&i.));
    set inputDS;

    select;
      %doLoop(0,&x.-1,%nrstr( when(mod(var,&x.) = &j.) output red_&j.; ),index=j)      
      otherwise do; 
          put "ERROR: wrong value!!";
          put _all_;
        end;
    end;
  run;

)));
%mend secret7;


/* test 3 */
%macro unhide()/parmbuff;
  %put ###&syspbuff###;
%mend unhide;

options mprint mlogic symbolgen ls=120 ps=max;

%unhide(%secret7(5))

options nomprint nomlogic nosymbolgen;



* Example 3: Loops in data step */

resetline;



%macro secret7(x) / secure;
%local rc;
%let rc = %sysfunc(doSubL(%nrstr(
  options ps=min nomlogic nosymbolgen nomprint nosource nosource2;

  data %doLoop(0,&x.-1,%nrstr( part_&i.));
    set sashelp.cars;

    select;
      %doLoop(0,&x.-1,%nrstr( when(mod(_N_,&x.) = &j.) output part_&j.; ),index=j)      
      otherwise do; 
          put "ERROR: wrong value!!";
          put _all_;
        end;
    end;
  run;

)));
%mend secret7;


/* test 3 */
%macro unhide()/parmbuff;
  %put ###&syspbuff###;
%mend unhide;

options mprint mlogic symbolgen ls=120 ps=max;

%unhide(%secret7(5))

options nomprint nomlogic nosymbolgen;







