/*** HELP START ***//*
 
## >>> `%appendArray()` macro: <<< <a name="appendarray-macro"></a> ############

The `%appendArray()` macro is a macrowrapper
which allows to concatenate two macroarrays 
created by `%array()` macro.

By default values of the second macroarray are *not* removed.

Dimensions of the first macroarray are extended.

The `%appendArray()` macro executes like a pure macro code.

### SYNTAX: #####################################################################

The basic syntax is the following, the `<...>` means optional parameters:
~~~~~~~~~~~~~~~~~~~~~~~sas
%appendArray(
  first
 ,second
) 
~~~~~~~~~~~~~~~~~~~~~~~

**Arguments description**:

1. `first` -  *Required*, a name of a macroarray created by the `%array()` macro.

2. `second` - *Required*, a name of a macroarray created by the `%array()` macro.

*//*** HELP END ***/

 %macro appendArray(
  first
, second
);
%concatArrays(&first., &second., removeSecond=N)
%mend appendArray;

/*** HELP START ***//*
 
### EXAMPLES AND USECASES: ######################################################

**EXAMPLE 1.** Append macroarrays LL and MM.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %array(ll[2:4] $ 12,
    function = quote(put(today() + 10*_I_, yymmdd10.)),
    macarray=Y
  )
  %array(mm[10:13] $ 1200,
    function = quote(repeat("A",12*_I_)),
    macarray=Y
  )
  %put *%ll(2)*%ll(3)*%ll(4)*;

  %appendArray(ll, mm); 
  %put *%ll(2)*%ll(3)*%ll(4)*%ll(5)*%ll(6)**%ll(7)*%ll(8)*;

  %put *%mm(10)**%mm(11)*%mm(12)*%mm(13)*;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**EXAMPLE 2.** Error handling.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %appendArray(ll, )
  %appendArray(, mm)

  %appendArray(noExistA, noExistB)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
---

*//*** HELP END ***/

/**###################################################################**/
/*                                                                     */
/*  Copyright Bartosz Jablonski, February 2019.                        */
/*                                                                     */
/*  Code is free and open source. If you want - you can use it.        */
/*  But it comes with absolutely no warranty whatsoever.               */
/*  If you cause any damage or something - it will be your own fault.  */
/*  You've been warned! You are using it on your own risk.             */
/*  However, if you decide to use it don't forget to mention author.   */
/*  Bartosz Jablonski (yabwon@gmail.com)                               */
/*                                                                     */
/**###################################################################**/
