/*** HELP START ***//*
 
## >>> `%deleteMacArray()` macro: <<< <a name="deletemacarray-macro"></a> #######

The `%deleteMacArray()` macro allows to delete
macroarrays created by the `%array()` macro.

The `%deleteMacArray()` macro executes like a pure macro code.

### SYNTAX: #####################################################################

The basic syntax is the following, the `<...>` means optional parameters:
~~~~~~~~~~~~~~~~~~~~~~~sas
%deleteMacArray(
  arrs
 <,macarray=N>
) 
~~~~~~~~~~~~~~~~~~~~~~~

**Arguments description**:

1. `arrs` -      *Required*, a space separated list of manes 
                 of macroarray created by the `%array()` macro.
               
* `macarray=N` - *Optional*, indicator should a macro 
                 associated with macroarray to be deleted? 
                 If `Y` or `YES` then the associated macro is deleted.

*//*** HELP END ***/

%macro deleteMacArray(
  arrs
, macarray = N
) 
/ minoperator 
;
%local I J rc;
%do I = 1 %to %sysfunc(countw(&arrs.));
%let arr = %scan(&arrs., &I., %str( ));
  %do J = &&&arr.LBOUND %to &&&arr.HBOUND;
    /*%put *&arr.&J.*;*/
    %symdel &arr.&J. / NOWARN;
  %end;
  %symdel &arr.LBOUND &arr.HBOUND &arr.N / NOWARN;
%end;

%if %qupcase(&macarray.) in (Y YES) %then
  %do;
  %let rc = %sysfunc(dosubl(
  /*+++++++++++++++++++++++++++++++++++++++++++++*/
  options nonotes nosource %str(;)
  proc sql noprint %str(;)
    create table _%sysfunc(datetime(), hex16.)_ as
    select memname %str(,) objname
    from dictionary.catalogs
    where 
      objname in (%upcase(
      %str(%")%qsysfunc(tranwrd(&arrs., %str( ), %str(%",%")))%str(%")
      ))
      and objtype = 'MACRO'
      and libname  = 'WORK'
    order by memname %str(,) objname
    %str(;)
  quit %str(;)
  data _null_ %str(;)
    do until(last.memname) %str(;)
      set _last_ %str(;)
      by memname %str(;)

      if first.memname then 
      call execute('proc catalog cat = work.' 
                 !! strip(memname) 
                 !! ' et = macro force;') %str(;)
      call execute('delete ' 
                 !! strip(objname) 
                 !! '; run;') %str(;)
    end %str(;)
    call execute('quit;') %str(;)
  run %str(;)
  proc delete data = _last_ %str(;)
  run %str(;)
  /*+++++++++++++++++++++++++++++++++++++++++++++*/
  ));
  %end; 
%mend deleteMacArray;

/*** HEPL START ***//*
 
### EXAMPLES AND USECASES: ####################################################

**EXAMPLE 1.** Delete macroarray.
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %array(myArr[0:45] $ 11, function = put(intnx("MONTH", '1jun2018'd, _I_, "E"), yymmn.))
  %put &=myArrLBOUND. &=myArrHBOUND. &=myArrN.;
  %put _user_;

  %deleteMacArray(myArr)
  %put _user_;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**EXAMPLE 2.** Delete macroarray and its macro.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %array(myBrr[3] (1 2 3), macarray = Y)
  %put &=myBrrLBOUND. &=myBrrHBOUND. &=myBrrN.;
  %put %myBrr(1) # %myBrr(2) # %myBrr(3);

  %deleteMacArray(myBrr, macarray=Y)
  %put &=myBrrLBOUND. &=myBrrHBOUND. &=myBrrN.;
  %put %myBrr(1) # %myBrr(2) # %myBrr(3);
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
---
*//*** HEPL END ***/

/**###################################################################**/
/*                                                                     */
/*  Copyright Bartosz Jablonski, since January 2019.                   */
/*                                                                     */
/*  Code is free and open source. If you want - you can use it.        */
/*  But it comes with absolutely no warranty whatsoever.               */
/*  If you cause any damage or something - it will be your own fault.  */
/*  You've been warned! You are using it on your own risk.             */
/*  However, if you decide to use it don't forget to mention author.   */
/*  Bartosz Jablonski (yabwon@gmail.com)                               */
/*                                                                     */
/**###################################################################**/
