/*** HELP START ***//*
 
## >>> `%do_over2()` macro: <<< <a name="do-over2-macro"></a>####################

The code of the macro was inspired by 
*Ted Clay's* and *David Katz's* macro `%do_over()`.

The `%DO_OVER2()` macro allows to iterate over *two* macroarray created with 
the `macarray=Y` parameter of the `%ARRAY()` macro.

The `%do_over2()` macro executes like a pure macro code.

### SYNTAX: #####################################################################

The basic syntax is the following, the `<...>` means optional parameters:
~~~~~~~~~~~~~~~~~~~~~~~sas
%do_over2(
  arrayI
 ,arrayJ
 <,phrase=%nrstr(%&arrayI(&_I_.) %&arrayJ(&_J_.))>
 <,between=%str( )>
)
~~~~~~~~~~~~~~~~~~~~~~~

**Arguments description**:

1. `arrayI` -  Required, indicates the first macroarray which metadata (Lbound, Hbouns)
               are to be used in the outer loop in the `%do_over2()`

2. `arrayJ` -  Required, indicates the second macroarray which metadata (Lbound, Hbouns)
               are to be used in the inner loop in the `%do_over2()`

* `phrase=` -  *Optional*, default value `%nrstr(%&arrayI(&_I_.) %&arrayJ(&_J_.))`, 
               a statement to be called in each iteration 
               of the *inner* loop. The outer loop iterator is `_I_`,
               the inner loop iterator is `_J_`,
               if you want to use `_I_`, `_J_`, or arrays names 
               [e.g. `%myArr(&_I_.)`] *enclose them* in the `%NRSTR()` 
               macro quoting function. 

* `between=` - *Optional*, default value `%str( )` (space), 
               a statement to be called in between each 
               iteration of the internal do_over2 loop.
               If macroquoted (e.g. `%str( + )`) then the `%unquote()` 
               function is automatically applied.

*//*** HELP END ***/

%macro do_over2(
  arrayI
, arrayJ
, phrase=%nrstr(%&arrayI(&_I_.) %&arrayJ(&_J_.))
, between=%str( )
);
  %local _I_ _J_;
  %do _I_ = &&&arrayI.LBOUND %to &&&arrayI.HBOUND;
    %do _J_ = &&&arrayJ.LBOUND %to &&&arrayJ.HBOUND;
    %if not (
            &_I_. = &&&arrayI.LBOUND 
        AND &_J_. = &&&arrayJ.LBOUND
        ) 
    %then %do;%unquote(&between.)%end;%unquote(%unquote(&phrase.))
    %end;
  %end;
%mend do_over2;

/*** HELP START ***//*
 
### EXAMPLES AND USECASES: ####################################################

**EXAMPLE 1.** Looping over two arrays.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %array(alpha[*] j k l m n, vnames=Y, macarray=Y)
  %array( beta[4] (101 102 103 104),   macarray=Y)

  %put *%do_over2(alpha, beta
  , phrase = %NRSTR((%alpha(&_I_.), %beta(&_J_)))
  )*;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**EXAMPLE 2.** Looping over two arrays with a separator.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %array(alpha[11] (5:15),            macarray=Y)
  %array( beta[ 4] (101 102 103 104), macarray=Y)

  %let x = %do_over2(alpha, beta
  , phrase = %NRSTR((%alpha(&_I_.) * %beta(&_J_)))
  , between= + 
  );
  %put &=x.;
  %put %sysevalf(&x.);
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**EXAMPLE 3.** Looping over two arrays with *macroquoted* separator.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %array(alpha[11] (5:15),            macarray=Y)
  %array( beta[ 4] (101 102 103 104), macarray=Y)

  %let x = %do_over2(alpha, beta
  , phrase = %NRSTR((%alpha(&_I_.) * %beta(&_J_)))
  , between= %str( + )
  );
  %put &=x.;
  %put %sysevalf(&x.);
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
---
*//*** HELP END ***/

/**###################################################################**/
/*                                                                     */
/*  Copyright Bartosz Jablonski, since January 2019.                   */
/*                                                                     */
/*  Code is free and open source. If you want - you can use it.        */
/*  But it comes with absolutely no warranty whatsoever.               */
/*  If you cause any damage or something - it will be your own fault.  */
/*  You've been warned! You are using it on your own risk.             */
/*  However, if you decide to use it don't forget to mention author.   */
/*  Bartosz Jablonski (yabwon@gmail.com)                               */
/*                                                                     */
/**###################################################################**/
