/*** HELP START ***//*
 
## >>> `%do_over3()` macro: <<< <a name="do-over3-macro"></a>####################

The code of the macro was inspired by 
*Ted Clay's* and *David Katz's* macro `%do_over()`.

The `%DO_OVER3()` macro allows to iterate over *three* macroarray created with 
the `macarray=Y` parameter of the `%ARRAY()` macro.

The `%do_over3()` macro executes like a pure macro code.

### SYNTAX: #####################################################################

The basic syntax is the following, the `<...>` means optional parameters:
~~~~~~~~~~~~~~~~~~~~~~~sas
%do_over2(
  arrayI
 ,arrayJ
 ,arrayK
 <,phrase=%nrstr(%&arrayI(&_I_.) %&arrayJ(&_J_.) %&arrayK(&_K_.))>
 <,between=%str( )>
)
~~~~~~~~~~~~~~~~~~~~~~~

**Arguments description**:

1. `arrayI` -  *Required*, indicates the first macroarray which metadata (Lbound, Hbouns)
               are to be used in the outer loop in the `%do_over3()`

2. `arrayJ` -  *Required*, indicates the second macroarray which metadata (Lbound, Hbouns)
               are to be used in the inner loop in the `%do_over3()`

3. `arrayK` -  *Required*, indicates the third macroarray which metadata (Lbound, Hbouns)
               are to be used in the inner loop in the `%do_over3()`

* `phrase=` -  *Optional*, default value `%nrstr(%&arrayI(&_I_.) %&arrayJ(&_J_.) %&arrayK(&_K_.))`, 
               a statement to be called in each iteration 
               of the *inner* loop. The *outer* loop iterator is `_I_`,
               the *middle* loop iterator is `_J_`, the *inner* loop iterator is `_K_`,
               if you want to use `_I_`, `_J_`, `_K_`, or arrays names 
               [e.g. `%myArr(&_I_.)`] *enclose them* in the `%NRSTR()` 
               macro quoting function. 

* `between=` - *Optional*, default value `%str( )` (space), 
               a statement to be called in between each 
               iteration of the internal do_over2 loop.
               If macroquoted (e.g. `%str( + )`) then the `%unquote()` 
               function is automatically applied.

*//*** HELP END ***/

%macro do_over3(
  arrayI 
, arrayJ 
, arrayK 
, phrase=%nrstr(%&arrayI(&_I_.) %&arrayJ(&_J_.) %&arrayK(&_K_.)) 
, between=%str( )
);
  %local _I_ _J_ _K_;
  %do _I_ = &&&arrayI.LBOUND %to &&&arrayI.HBOUND;
    %do _J_ = &&&arrayJ.LBOUND %to &&&arrayJ.HBOUND;
      %do _K_ = &&&arrayK.LBOUND %to &&&arrayK.HBOUND;
      %if not (
              &_I_. = &&&arrayI.LBOUND 
          AND &_J_. = &&&arrayJ.LBOUND
          AND &_K_. = &&&arrayK.LBOUND
          ) 
      %then %do;%unquote(&between.)%end;%unquote(%unquote(&phrase.))
      %end;
    %end;
  %end;
%mend do_over3;


/*** HELP START ***//*
 
### EXAMPLES AND USECASES: ####################################################

**EXAMPLE 1.** Looping over 3 macroarrays.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %array(a1_[2] (0 1), macarray=Y)
  %array(a2_[2] (2 3), macarray=Y)
  %array(a3_[2] (4 5), macarray=Y)

  %do_over3(a1_, a2_, a3_
  , phrase = %NRSTR(%put (%a1_(&_I_.), %a2_(&_J_), %a3_(&_K_));)
  )
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

**EXAMPLE 2.** Looping 3 times over a macroarray.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %array(a[0:2] (0 1 2), macarray=Y)

  %do_over3(a, a, a
  , phrase = %NRSTR(%put (%a(&_I_.), %a(&_J_), %a(&_K_));)
  )
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
---
*//*** HELP END ***/

/**###################################################################**/
/*                                                                     */
/*  Copyright Bartosz Jablonski, since January 2019.                   */
/*                                                                     */
/*  Code is free and open source. If you want - you can use it.        */
/*  But it comes with absolutely no warranty whatsoever.               */
/*  If you cause any damage or something - it will be your own fault.  */
/*  You've been warned! You are using it on your own risk.             */
/*  However, if you decide to use it don't forget to mention author.   */
/*  Bartosz Jablonski (yabwon@gmail.com)                               */
/*                                                                     */
/**###################################################################**/
