/*** HELP START ***//*
 
## >>> `%make_do_over()` macro: <<< <a name="make-do-over-macro"></a> ###########

The code of the macro was inspired by 
*Ted Clay's* and *David Katz's* macro `%do_over()`.

The `%make_do_over()` macro allows to generate
the `%DO_OVER<n>()` macros. It works *only* for *n>3*!

The `%make_do_over()` macro does *not* executes like a pure macro code.

### SYNTAX: #####################################################################

The basic syntax is the following, the `<...>` means optional parameters:
~~~~~~~~~~~~~~~~~~~~~~~sas
%make_do_over(
  size
)
~~~~~~~~~~~~~~~~~~~~~~~

**Arguments description**:

1. `size` - *Required*, indicates the number of dimensions 
            (i.e. inner loops) of the `%DO_OVER<n>()` macro.

*//*** HELP END ***/

/* The definition: */
%macro make_do_over(
size 
);
%if &size. > 3 %then
%do;
%local T ; %let T = _%sysfunc(datetime(),hex6.)_;
filename &T. TEMP lrecl=512;
data _null_;
  file &T.;
  length text $ 256 and $ 4;
  put '%macro do_over' "&size." '(';
  do i = 1 to &size.;
    text = cats('arrayI', i, ',');
    /* arrayI1, */ 
    put text;
  end;
  put '  phrase=%nrstr(';
  do i = 1 to &size.;
    text = cats('%&arrayI', i, '(&_I', i, '_.)'); 
    /* %&arrayI1(&_I1_.) */
    put text;
  end;
  put '),'; 
  put '  between=%str( )';
  put ');';
  put '  %local ';
  do i = 1 to &size.;
    text = cats('_I', i, '_');
    /* _I1_ */ 
    put text;
  end;
  put ';';
  do i = 1 to &size.;
    text = cats('%do _I', i, '_ = &&&arrayI', i, '.LBOUND %to &&&arrayI', i, '.HBOUND;');
    /* %do _I1_ = &&&arrayI1.LBOUND %to &&&arrayI1.HBOUND; */ 
    put text;
  end;
  put '  %if not (';

  do i = 1 to &size.;
    text = cats('&_I', i, '_. = &&&arrayI', i, '.LBOUND');
    and = ifc(i = 1, "    ", "AND ");
    /* <AND> &_I1_. = &&&arrayI1.LBOUND */ 
    put and text;
  end;
  put '    )';
  put '  %then %do;%unquote(&between.)%end;%unquote(%unquote(&phrase.))';
  do i = 1 to &size.;
    put '%end;';
  end;
  put '%mend;';
run;
%include &T.; /* / source2;*/
filename &T.;
%end;
%else
%do;
 %put NOTE:[&sysmacroname.] NO MACRO GENERATED FOR SIZE = &size.;
 %put NOTE-[&sysmacroname.] SIZE must be greater than 3!!!;
%end;
%mend make_do_over;

/*** HELP START ***//*
 
### EXAMPLES AND USECASES: ####################################################

**EXAMPLE 1.** Code of created "4-loop" `%DO_OVER4()` macro

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
    %macro do_over4(
      arrayI1, 
      arrayI2, 
      arrayI3, 
      arrayI4,
      phrase=%nrstr(
    %&arrayI1(&_I1_.)
    %&arrayI2(&_I2_.)
    %&arrayI3(&_I3_.)
    %&arrayI3(&_I4_.)
    ), 
      between=%str( )
    );
      %local _I1_ _I2_ _I3_ _I4_;
      %do _I1_ = &&&arrayI1.LBOUND %to &&&arrayI1.HBOUND;
      %do _I2_ = &&&arrayI2.LBOUND %to &&&arrayI2.HBOUND;
      %do _I3_ = &&&arrayI3.LBOUND %to &&&arrayI3.HBOUND;
      %do _I4_ = &&&arrayI4.LBOUND %to &&&arrayI4.HBOUND;
      %if not (
            &_I1_. = &&&arrayI1.LBOUND 
        AND &_I2_. = &&&arrayI2.LBOUND
        AND &_I3_. = &&&arrayI3.LBOUND
        AND &_I4_. = &&&arrayI4.LBOUND
        ) 
      %then %do;%unquote(&between.)%end;%unquote(%unquote(&phrase.))
      %end;
      %end;
      %end;
      %end;
    %mend do_over4;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**EXAMPLE 2.** Create a "4-loop" `%DO_OVER4()` macro

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %make_do_over(4);

  %array(a1_[2] (0 1), macarray=Y)

  %do_over4(a1_, a1_, a1_, a1_
  , phrase = %NRSTR(%put (%a1_(&_I1_.), %a1_(&_I2_), %a1_(&_I3_), %a1_(&_I4_));)
  )

  %put *%do_over4(a1_, a1_, a1_, a1_
  , between = *
  )*;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

**EXAMPLE 3.** Create a "5-loop" `%DO_OVER5()` macro

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %make_do_over(5);

  %array(a1_[2] (0 1), macarray=Y)

  %do_over5(a1_, a1_, a1_, a1_, a1_
  , phrase = %NRSTR(%put (%a1_(&_I1_.), %a1_(&_I2_), %a1_(&_I3_), %a1_(&_I4_), %a1_(&_I5_));)
  )

  %put *%do_over5(a1_, a1_, a1_, a1_, a1_
  , between = *
  )*
  ;

  options nomprint;
  data test2;
    %do_over5(a1_, a1_, a1_, a1_, a1_
    , phrase = %NRSTR(x1 = %a1_(&_I1_.); x2 = %a1_(&_I2_); x3 = %a1_(&_I3_); x4 = %a1_(&_I4_);  x5 = %a1_(&_I5_);)
    , between = output;
    )
  output;
  run;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**EXAMPLE 4.** Create all from 6 to 10 "do_overs"

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  %array(loop[6:10] (6:10), macarray=Y)
  %do_over(loop
    , phrase = %nrstr( 
      %make_do_over(%loop(&_I_.))
      )
  );
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
---
*//*** HELP END ***/

/**###################################################################**/
/*                                                                     */
/*  Copyright Bartosz Jablonski, since January 2019.                   */
/*                                                                     */
/*  Code is free and open source. If you want - you can use it.        */
/*  But it comes with absolutely no warranty whatsoever.               */
/*  If you cause any damage or something - it will be your own fault.  */
/*  You've been warned! You are using it on your own risk.             */
/*  However, if you decide to use it don't forget to mention author.   */
/*  Bartosz Jablonski (yabwon@gmail.com)                               */
/*                                                                     */
/**###################################################################**/
