/*** HELP START ***//*
 
## >>> `%zipArrays()` macro: <<< <a name="ziparrays-macro"></a> #######################  

The zipArrays() and QzipArrays() macros
allow to use a function on elements of pair of 
macro arrays. 

For two macroarrays the corresponding 
elements are taken and the macro applies a function, provided by user, 
to calculate result of the function on taken elements. 

When one of the arrays is shorter then elements are, by default, 
"reused" starting from the beginning. But this behaviour can be altered. 
See examples for the details.

By default newly created macroarray name is concatenation 
of first 13 characters of names of arrays used to create the new one, 
e.g. if arrays names are `abc` and `def` then the result name is `abcdef`,
if arrays names are `abcd1234567890` and `efgh1234567890` then the result 
name is `abcd123456789efgh123456789` 

The `zipArrays()` returns unquoted value [by `%unquote()`].
The `QzipArrays()` returns quoted value [by `%superq()`].

See examples below for the details.

The `%zipArrays()` macro executes like a pure macro code.

### SYNTAX: ###################################################################

The basic syntax is the following, the `<...>` means optional parameters:
~~~~~~~~~~~~~~~~~~~~~~~sas
%zipArrays(
    first
   ,second
  <,function=>
  <,operator=> 
  <,argBf=>
  <,argMd=>
  <,argAf=>
  <,format=>
  <,result=>
  <,macarray=>
  <,reuse=>
)
~~~~~~~~~~~~~~~~~~~~~~~

**Arguments description**:

1. `first`         - *Required*, a space separated list of texts.

2. `second`        - *Required*, a space separated list of texts.

* `function = cat` - *Optional*, default value is `cat`, 
                     a function which will be applied 
                     to corresponding pairs of elements of 
                     the first and the second list. 

* `operator =`     - *Optional*, default value is empty,
                     arithmetic infix operator used with elements 
                     the first and the second list. The first
                     list is used on the left side of the operator
                     the second list is used on the right side
                     of the operator. 

* `argBf =`        - *Optional*, default value is empty,
                     arguments of the function inserted
                     *before* elements the first list.
                     If multiple should be comma separated.

* `argMd =`        - *Optional*, default value is empty,
                     arguments of the function inserted
                     *between* elements the first list and 
                     the second list.
                     If multiple should be comma separated.

* `argAf =`        - *Optional*, default value is empty,
                     arguments of the function inserted
                     *after* elements the second list.
                     If multiple should be comma separated.

* `format=`        - *Optional*, default value is empty,
                     indicates a format which should be used
                     to format the result, does not work when 
                     the `operator=` is used.

* `result=`        - *Optional*, default value is empty,
                     indicates a name of newly created macroarray,
                     by default created macroarray name is concatenation 
                     of first 13 characters of names of arrays used 
                     to create the new one.

* `macarray=N`     - *Optional*, default value is `N`, 
                     if set to `Y`/`YES` then a macro, named with 
                     the array name, is compiled to create convenient 
                     envelope for multiple ampersands, see the 
                     `%array()` macro for details.

* `reuse=Y`        - *Optional*, default value is `Y`,
                     when one of the arrays is shorter then elements 
                     are *reused* starting from the beginning.
                     If `CP` then function  is executed on the *Cartesian 
                     product* of arrays elements. Any other value will
                     cut the process with the end of the shorter array.
                     See examples for the details.

*//*** HELP END ***/

%macro zipArrays(
   first
  ,second
  ,function = cat
  ,operator = 
  ,argBf=
  ,argMd=
  ,argAf=
  ,format=
  ,result=
  ,macarray=N
  ,reuse=Y
)
/
des='The %zipArrays() and %QzipArrays() macro functions allows to use a function on elements of pair of arrays.'
;
%local
  sepB sepM sepA 
  _Fk_ _Sk_ _Rk_
  _MAX_ _I_
;


%if (
  (&first. = ) or
  (&second.= )
) %then
  %do;
    %put WARNING: At least one of array symbols is empty!;
    %put WARNING- No action will be executed.;
    %RETURN;
  %end;

%if not (
  %symglobl(&first.HBOUND ) and
  %symglobl(&first.LBOUND ) and
  %symglobl(&first.N      ) and
  %symglobl(&second.HBOUND) and
  %symglobl(&second.LBOUND) and
  %symglobl(&second.N     )
) %then
  %do;
    %put WARNING: At least one of arrays is improper or undefined!;
    %put WARNING- No action will be executed.;
    %RETURN;
  %end;

%if (
  (&&&first.HBOUND  = ) or
  (&&&first.LBOUND  = ) or
  (&&&first.N       = ) or
  (&&&second.HBOUND = ) or
  (&&&second.LBOUND = ) or
  (&&&second.N      = )
) %then
  %do;
    %put WARNING: At least one of arrays is improper or undefined!;
    %put WARNING- No action will be executed.;
    %RETURN;
  %end;

%if %superq(result) = %then %let result = %sysfunc(substrn(&first.,1,13))%sysfunc(substrn(&second.,1,13));

%if \%superq(argBf)\ NE \\ %then %let sepB = ,;
%if \%superq(argMd)\ NE \\ %then %let sepM = ,;
%if \%superq(argAf)\ NE \\ %then %let sepA = ,;

%if %qupcase(&reuse.) = Y 
  %then %let _MAX_ = %sysfunc(MAX(&&&first.N, &&&second.N)); /* take longer */
  %else %if %qupcase(&reuse.) = CP 
    %then %let _MAX_ = %sysevalf(&&&first.N * &&&second.N); /* take Cartesian product */
    %else %let _MAX_ = %sysfunc(MIN(&&&first.N, &&&second.N)); /* take shorter */

    /*%put NOTE: &=_MAX_;*/

%if %qupcase(&reuse.) = CP %then
  %DO _Fk_ = &&&first.LBOUND %TO &&&first.HBOUND;
    %DO _Sk_ = &&&second.LBOUND %TO &&&second.HBOUND;
      %let _Rk_ = %eval(&_Rk_. + 1);

      %global &RESULT.&_Rk_.;
      %if %superq(operator)= %then
        %do;
          %let &RESULT.&_Rk_. = %qsysfunc(&function.(&argBf.&sepB.
                                                     %superq(&first.&_Fk_.)
                                                     &sepM.&argMd.
                                                    ,%superq(&second.&_Sk_.)
                                                     &sepA.&argAf.) 
                                         ,&format.);
          /*%put >>%superq(_RESULT_)<<;*/
        %end;
      %else
        %do;
          %let &RESULT.&_Rk_. = %sysevalf(%superq(&first.&_Fk_.) &operator. %superq(&second.&_Sk_.)) ;
        %end;

      %let &RESULT.&_Rk_. = %unquote(&&&RESULT.&_Rk_.);
    %END;
  %END;
%else
  %DO _I_ = 0 %TO %eval(&_MAX_.-1);
    %let _Rk_ = %eval(1 + &_I_.);
    %let _Fk_ = %eval(&&&first.LBOUND  + %sysfunc(mod(&_I_., &&&first.N )); 
    %let _Sk_ = %eval(&&&second.LBOUND + %sysfunc(mod(&_I_., &&&second.N)); 

    %global &RESULT.&_Rk_.;
    %if %superq(operator)= %then
      %do;
        %let &RESULT.&_Rk_. = %qsysfunc(&function.(&argBf.&sepB.
                                                   %superq(&first.&_Fk_.)
                                                   &sepM.&argMd.
                                                  ,%superq(&second.&_Sk_.)
                                                   &sepA.&argAf.) 
                                       ,&format.);
        /*%put >>%superq(_RESULT_)<<;*/
      %end;
    %else
      %do;
        %let &RESULT.&_Rk_. = %sysevalf(%superq(&first.&_Fk_.) &operator. %superq(&second.&_Sk_.)) ;
      %end;

    %let &RESULT.&_Rk_. = %unquote(&&&RESULT.&_Rk_.);
  %END;

%global &RESULT.N &RESULT.LBOUND &RESULT.HBOUND;
%let &RESULT.N      = &_MAX_.;
%let &RESULT.LBOUND = 1;
%let &RESULT.HBOUND = &_MAX_.;
%put NOTE:[&sysmacroname.] &_MAX_. macrovariables created;

%if %qupcase(&macarray.) = Y or %qupcase(&macarray.) = YES %then
  %do;
  /*-----------------------------------------------------------------------------------------------------------*/
    %put NOTE-; 
    %put NOTE: When macarray= parameter is active the zipArrays macro cannot be called within the %nrstr(%%put) statement.;
    %put NOTE: Execution like: %nrstr(%%put %%zipArrays(..., macarray=Y)) will result with an e.r.r.o.r.; 
               /*e.r.r.o.r. - explicit & radical refuse of run */
    %put NOTE-; 

    %local mtext rc;
    %let mtext = _%sysfunc(int(%sysevalf(1000000000 * %sysfunc(rand(uniform)))))_;
    %let rc = %sysfunc(doSubL( /*%nrstr(%%put ;)*/
    /*===============================================================================================*/
      options nonotes nosource %str(;) 
      DATA _NULL_ %str(;) 
       CALL SYMPUTX("&mtext.",  
        ' %MACRO ' !! "&RESULT." !! '(J,M);' !!
        '%local J M; %if %qupcase(&M.)= %then %do;' !! /* empty value is output, I is input */
        '%if %sysevalf( (&&&sysmacroname.LBOUND LE &J.) * (&J. LE &&&sysmacroname.HBOUND) ) %then %do;&&&sysmacroname.&J.%end;' !!
        '%else %do; ' !!
          '%put WARNING:[Macroarray &sysmacroname.] Index &J. out of range.;' !!
          '%put WARNING-[Macroarray &sysmacroname.] Should be between &&&sysmacroname.LBOUND and &&&sysmacroname.HBOUND;' !!
          '%put WARNING-[Macroarray &sysmacroname.] Missing value is used.;' !!
        '%end;' !!
        '%end;' !!
        '%else %do; %if %qupcase(&M.)=I %then %do;' !!
        '%if %sysevalf( (&&&sysmacroname.LBOUND LE &J.) * (&J. LE &&&sysmacroname.HBOUND) ) %then %do;&sysmacroname.&J.%end;' !!
        '%else %do;' !!
          '%put ERROR:[Macroarray &sysmacroname.] Index &J. out of range.;' !!
          '%put ERROR-[Macroarray &sysmacroname.] Should be between &&&sysmacroname.LBOUND and &&&sysmacroname.HBOUND;' !!
        '%end;' !!
        '%end; %end;' !!
        '%MEND;', 'G') %str(;)
       STOP %str(;) 
      RUN %str(;) 
    /*===============================================================================================*/
    )); &&&mtext. %symdel &mtext. / NOWARN ;
  /*-----------------------------------------------------------------------------------------------------------*/ 
  %end;

/*%superq(_RESULT_)*/
/*%unquote(&_RESULT_.)*/
%RETURN;
%mend zipArrays;

/*** HELP START ***//*
 
### EXAMPLES AND USECASES: ####################################################

**EXAMPLE 1.** Simple concatenation of elements:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
%array(a[*] x1-x3 (1:3))
%array(b[*] x1-x5 (11:15))

%put _user_;

%zipArrays(a, b);
%put _user_;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**EXAMPLE 2.** Shorter list is "reused":
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
%array(a[6] (1:6))
%array(b[3] (10 20 30))

%zipArrays(a, b, result=A_and_B, macarray=Y);
%put %do_over(A_and_B);
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**EXAMPLE 3.** Use of the `operator=`:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
%array(c[0:4] (000 100 200 300 400))
%array(d[2:16] (1002:1016))

%zipArrays(c, d, operator=+, result=C_plus_D, macarray=Y);
%put (%do_over(C_plus_D));

%put %C_plus_D(1);
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**EXAMPLE 4.** If one of array names is empty or an array does not exist:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
%array(a[6] (1:6))
%array(b[3] (10 20 30))

%zipArrays(a, );
%zipArrays(, b);

%zipArrays(a, z);
%zipArrays(z, b);
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**EXAMPLE 5.** Use of the `function=`:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
%array(one[3] A B C, vnames=Y)
%array(two[5] p q r s t, vnames=Y)

%zipArrays(
 one
,two
,function = catx
,argBf = %str( )
,format = $quote.
,macarray=Y
)
%put %do_over(onetwo);
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**EXAMPLE 6.** To reuse or not to reuse, or maybe Cartesian product:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
%array(e[3] (10 20 30))
%array(f[2] (5:6))

%zipArrays(e, f, reuse=n,  operator=+, macarray=Y, result=_noReuse);
%zipArrays(e, f, reuse=y,  operator=+, macarray=Y, result=_yesReuse);
%zipArrays(e, f, reuse=cp, operator=+, macarray=Y, result=_cartProdReuse);

%put %do_over(_noReuse);
%put %do_over(_yesReuse);
%put %do_over(_cartProdReuse);
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


**EXAMPLE 7.** Use middle argument:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
%array(yr[3] (2018:2020))
%array(mth[12] (1:12))

%zipArrays(mth, yr, argMd=5, function=MDY, format=date11., macarray=Y);
%put %do_over(mthyr);

%zipArrays(mth, yr, argMd=5, function=MDY, format=date11., macarray=Y, reuse=cp);
%put %do_over(mthyr);
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

---
*//*** HELP END ***/

/**###################################################################**/
/*                                                                     */
/*  Copyright Bartosz Jablonski, since January 2019.                   */
/*                                                                     */
/*  Code is under the MIT license. If you want - you can use it.       */
/*  But it comes with absolutely no warranty whatsoever.               */
/*  If you cause any damage or something - it will be your own fault.  */
/*  You've been warned! You are using it on your own risk.             */
/*  However, if you decide to use it don't forget to mention author.   */
/*  Bartosz Jablonski (yabwon@gmail.com)                               */
/*                                                                     */
/**###################################################################**/

