/* This is the description file for the package.         */
/* The colon (:) is a field separator and is restricted */
/* in lines of the header part.                          */

/* **HEADER** */
Type: Package                                    :/*required, not null, constant value*/
Package: macroArray                              :/*required, not null*/
Title: Macroarrays for macro codes               :/*required, not null*/
Version: 1.2.6                                   :/*required, not null*/
Author: Bartosz Jablonski (yabwon@gmail.com)     :/*required, not null*/
Maintainer: Bartosz Jablonski (yabwon@gmail.com) :/*required, not null*/
License: MIT
Encoding: UTF8                                   :/*required, not null*/

Required: "Base SAS Software"                    :

/* **DESCRIPTION** */
/* All the text below will be used in help */
DESCRIPTION START:

# The macroArray package [ver. 1.2.6] <a name="macroarray-package"></a> ###############################################

The **macroArray** package implements a macroarray facility:
- `%array()`,
- `%do_over()`,
- `%make_do_over()`,
- `%deletemacarray()`,
- `%concatarrays()`,
- `%appendcell()`,
- `%mcHashTable()`,
- `%zipArrays()`,
- `%sortMacroArray()`,
- `%mcDictionary()`,
- etc.

The set of macros, which emulates classic
data-step-array functionality on the macro
programming level, is provided.

*Note:*
If you are working with BIG macroarrays do not 
forget to verify your session setting for macro 
memory limits. Run:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~sas
  proc options group = macro;
  run;
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
to verify the following options: 

| option       | description                                                                                    |
|-------------:|:-----------------------------------------------------------------------------------------------|
|`MEXECSIZE=`  | specifies the maximum macro size that can be executed in memory.                               |
|`MSYMTABMAX=` | specifies the maximum amount of memory available to the macro variable symbol table or tables. |
|`MVARSIZE=`   | specifies the maximum size for a macro variable that is stored in memory.                      |

---
DESCRIPTION END:

/* TODO: [in Polish]
[v] rozszerzenie macra ARRAY, ktore zrobi "macroarray" dla istniejacej juz listy zmiennych,
[v] macro Zip, ktore bedzie "laczyc" dwie makro tablice z uzyciem wskazanej funkcji jak zamek blyskawiczny,
[ ] macro analogiczne do macra Zip, ktore robi to samo, ale na produkcie kartezjanskim 2 makrotablic,
*/
