filename P7B224D3 list;

%put NOTE: Unloading package macroArray, version 1.2.6, license MIT;
%put NOTE- *** START ***;

proc sql;
  create table WORK._%sysfunc(datetime(), hex16.)_ as
  select memname, objname, objtype
  from dictionary.catalogs
  where 
  (
   objname in ("*"
   ,'MACROARRAYIML'
   ,'MACROARRAYCASLUDF'

   %put NOTE- Element of type macro generated from the file "appendarray.sas" will be deleted;
   %put NOTE- ;
   ,"APPENDARRAY                     "

   %put NOTE- Element of type macro generated from the file "appendcell.sas" will be deleted;
   %put NOTE- ;
   ,"APPENDCELL                      "

   %put NOTE- Element of type macro generated from the file "array.sas" will be deleted;
   %put NOTE- ;
   ,"ARRAY                           "

   %put NOTE- Element of type macro generated from the file "concatarrays.sas" will be deleted;
   %put NOTE- ;
   ,"CONCATARRAYS                    "

   %put NOTE- Element of type macro generated from the file "deletemacarray.sas" will be deleted;
   %put NOTE- ;
   ,"DELETEMACARRAY                  "

   %put NOTE- Element of type macro generated from the file "do_over.sas" will be deleted;
   %put NOTE- ;
   ,"DO_OVER                         "

   %put NOTE- Element of type macro generated from the file "do_over2.sas" will be deleted;
   %put NOTE- ;
   ,"DO_OVER2                        "

   %put NOTE- Element of type macro generated from the file "do_over3.sas" will be deleted;
   %put NOTE- ;
   ,"DO_OVER3                        "

   %put NOTE- Element of type macro generated from the file "make_do_over.sas" will be deleted;
   %put NOTE- ;
   ,"MAKE_DO_OVER                    "

   %put NOTE- Element of type macro generated from the file "mcdictionary.sas" will be deleted;
   %put NOTE- ;
   ,"MCDICTIONARY                    "

   %put NOTE- Element of type macro generated from the file "mchashtable.sas" will be deleted;
   %put NOTE- ;
   ,"MCHASHTABLE                     "

   %put NOTE- Element of type macro generated from the file "qziparrays.sas" will be deleted;
   %put NOTE- ;
   ,"QZIPARRAYS                      "

   %put NOTE- Element of type macro generated from the file "sortmacroarray.sas" will be deleted;
   %put NOTE- ;
   ,"SORTMACROARRAY                  "

   %put NOTE- Element of type macro generated from the file "ziparrays.sas" will be deleted;
   %put NOTE- ;
   ,"ZIPARRAYS                       "

  )
  and objtype = "MACRO"
  and libname  = "WORK"
  )
  or
  (
   objname in ("*"

  )
  and objtype in ("FORMAT" "FORMATC" "INFMT" "INFMTC")
  and libname  = "WORK"
  and memname = 'MACROARRAYFORMAT'
  )
  order by objtype, memname, objname
  ;
quit;
data _null_;
  do until(last.memname);
    set WORK._last_;
    by objtype memname;
    if first.memname then call execute("proc catalog cat = work." !! strip(memname) !! " force;");
    call execute("delete " !! strip(objname) !! " /  et =" !! objtype !! "; run;");
  end;
  call execute("quit;");
run;
proc delete data = WORK._last_;
run;
proc fcmp outlib = work.macroarrayfcmp.package;
run;

proc sql noprint;
quit;

run;

data _null_ ;                                                                                        
  length SYSloadedPackages $ 32767;                                                                   
  if SYMEXIST("SYSloadedPackages") = 1 and SYMGLOBL("SYSloadedPackages") = 1 then                     
    do;                                                                                               
      do until(EOF);                                                                                  
        set sashelp.vmacro(where=(scope="GLOBAL" and name="SYSLOADEDPACKAGES")) end=EOF;              
        substr(SYSloadedPackages, 1+offset, 200) = value;                                             
      end;                                                                                            
      SYSloadedPackages = cats("#", translate(strip(SYSloadedPackages), "#", " "), "#");              
      if INDEX(lowcase(SYSloadedPackages), '#macroarray(1.2.6)#') > 0 then    
         do;                                                                                          
          SYSloadedPackages = tranwrd(SYSloadedPackages, '#macroArray(1.2.6)#', '##');  
          SYSloadedPackages = compbl(translate(SYSloadedPackages, " ", "#"));                         
          call symputX("SYSloadedPackages", SYSloadedPackages, "G");                                  
          put "NOTE: " SYSloadedPackages = ;                                                          
         end ;                                                                                        
    end;                                                                                              
  stop;                                                                                               
run;                                                                                                  

%put NOTE: Unloading package macroArray, version 1.2.6, license MIT;
%put NOTE- *** END ***;
%put NOTE- ;

/* unload.sas end */
