filename P948C2DF list;

%put NOTE: Unloading package SQLinDS, version 2.3.0, license MIT;
%put NOTE- *** START ***;

proc sql;
  create table WORK._%sysfunc(datetime(), hex16.)_ as
  select memname, objname, objtype
  from dictionary.catalogs
  where 
  (
   objname in ("*"
   ,'SQLINDSIML'
   ,'SQLINDSCASLUDF'

   %put NOTE- Element of type macro generated from the file "dssql_inner.sas" will be deleted;
   %put NOTE- ;
   ,"DSSQL_INNER                     "

   %put NOTE- Element of type macro generated from the file "sql.sas" will be deleted;
   %put NOTE- ;
   ,"SQL                             "

  )
  and objtype = "MACRO"
  and libname  = "WORK"
  )
  or
  (
   objname in ("*"

  )
  and objtype in ("FORMAT" "FORMATC" "INFMT" "INFMTC")
  and libname  = "WORK"
  and memname = 'SQLINDSFORMAT'
  )
  order by objtype, memname, objname
  ;
quit;
data _null_;
  do until(last.memname);
    set WORK._last_;
    by objtype memname;
    if first.memname then call execute("proc catalog cat = work." !! strip(memname) !! " force;");
    call execute("delete " !! strip(objname) !! " /  et =" !! objtype !! "; run;");
  end;
  call execute("quit;");
run;
proc delete data = WORK._last_;
run;
proc fcmp outlib = work.sqlindsfcmp.package;
%put NOTE- Element of type function generated from the file "dssql.sas" will be deleted;
%put NOTE- ;
deletefunc dssql ;

run;

options cmplib = (%unquote(%sysfunc(tranwrd(
%lowcase(%sysfunc(getoption(cmplib)))
,%str(work.sqlindsfcmp), %str() ))));
options cmplib = (%unquote(%sysfunc(compress(
%sysfunc(getoption(cmplib))
,%str(()) ))));
%put; %put NOTE:[CMPLIB] %sysfunc(getoption(cmplib));

proc sql noprint;
quit;

%put NOTE- Element of type libname generated from the file "dssql.sas" will be cleared;
%put NOTE- ;
libname dssql  clear;

run;

data _null_ ;                                                                                        
  length SYSloadedPackages $ 32767;                                                                   
  if SYMEXIST("SYSloadedPackages") = 1 and SYMGLOBL("SYSloadedPackages") = 1 then                     
    do;                                                                                               
      do until(EOF);                                                                                  
        set sashelp.vmacro(where=(scope="GLOBAL" and name="SYSLOADEDPACKAGES")) end=EOF;              
        substr(SYSloadedPackages, 1+offset, 200) = value;                                             
      end;                                                                                            
      SYSloadedPackages = cats("#", translate(strip(SYSloadedPackages), "#", " "), "#");              
      if INDEX(lowcase(SYSloadedPackages), '#sqlinds(2.3.0)#') > 0 then    
         do;                                                                                          
          SYSloadedPackages = tranwrd(SYSloadedPackages, '#SQLinDS(2.3.0)#', '##');  
          SYSloadedPackages = compbl(translate(SYSloadedPackages, " ", "#"));                         
          call symputX("SYSloadedPackages", SYSloadedPackages, "G");                                  
          put "NOTE: " SYSloadedPackages = ;                                                          
         end ;                                                                                        
    end;                                                                                              
  stop;                                                                                               
run;                                                                                                  

%put NOTE: Unloading package SQLinDS, version 2.3.0, license MIT;
%put NOTE- *** END ***;
%put NOTE- ;

/* unload.sas end */
